/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elItem: '.select-item',
		elDate: '.date-log',

		urlRequestData: window.APP.siteUrl + 'adm/report_stocks/get_data_detail_card',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					item_name: '',
					date_log: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_item = $(that.elItem).val();
						var val_date = $(that.elDate).val();

						var text_item = $(that.elItem + ' option:selected').text();

						vue.$set(vue, 'item_name', text_item);
						vue.$set(vue, 'date_log', val_date);

						if (val_item == "") {
							toastr.warning('Silahkan pilih barang terlebih dahulu!')
						} else {
							$.ajax({
								url: that.urlRequestData,
								type: 'post',
								data: {
									'item': val_item,
									'date_log': val_date
								},
								dataType: "json",
								beforeSend: function () {
									$(that.elVue).block({
										message: '<h4>Please Wait..</h4>'
									});
								},
								success: function (response) {
									vue.$set(vue, 'detailData', response);
									$(that.elVue).unblock();
								}
							});
						}
					},

					exportExcel: function () {
						var vue = this;

						var val_item = $(that.elItem).val();
						if (val_item == "") {
							toastr.warning('Silahkan pilih barang terlebih dahulu!')
						} else {
							vue.getData();

							setTimeout(function () {
								window.location = window.APP.siteUrl + 'adm/report_stocks/export_excel_card';
							}, 500);
						}
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);