/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elKelas: '.select-kelas',
		elStatus: '.select-status',
		elDate1: '.date1',
		elDate2: '.date2',

		urlRequestData: window.APP.siteUrl + 'adm/report_balance/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					date1: '',
					date2: '',
					kelas: '',
					status: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;

						var val_date1  = $(that.elDate1).val();
						var val_date2  = $(that.elDate2).val();
						var val_kelas  = $(that.elKelas).val();
						var val_status = $(that.elStatus).val();

						var text_kelas = $(that.elKelas + ' option:selected').text();
						var text_status = $(that.elStatus + ' option:selected').text();
						

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'date1': val_date1,
								'date2': val_date2,
								'kelas': val_kelas,
								'status': val_status,
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response['data']);

								console.log(response['data']);

								vue.$set(vue, 'date1', response['date1']);
								vue.$set(vue, 'date2', response['date2']);
								vue.$set(vue, 'kelas', text_kelas);
								vue.$set(vue, 'status', text_status);

								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_debts/export_excel';
						}, 500);
					}
				},
				mounted: function () {
					
				}
			});

		},

	}

})(jQuery);