/**
 * Javascript Student
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
		return checkbox;
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/student/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Click to Edit">' + data + '</a>';
	}

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',
		elTable: '#master-table',
		elModal: '.master-modal',
		elBtnDelete: '.master-delete',
		elModalClose: '.master-cancel',
		elSubCheckbox: '.check-sub-master',
		elParentCheckbox: '.check-all-master',
		elModalContent: '.master-modal-content',
		urlDeleteData: window.APP.siteUrl + 'adm/student/delete',
		urlRequestData: window.APP.siteUrl + 'adm/student/get_data',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				methods: {
					addRowType: function () {
						var vue = this;
					}
				},
				mounted: function () {
					parentThis.handleDataTable();
				}
			});

		},

		handleCheckbox: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},

		// Student : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			// Datatable
			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url: parentThis.urlRequestData
				},
				columns: [{
						data: 'no',
						width: '20',
						render: renderCheckbox
					},
					{
						data: 'code',
						render: renderEdit,
					},
					{
						data: 'name',
					},
					{
						data: 'gender',
					},
					{
						data: 'parent_name',
					},
					{
						data: 'parent_phone',
					},
					{
						data: 'address',
					},
					{
						data: 'grade',
					},
					{
						data: 'limit',
					}
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {

					// handle form
					window.FORM.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatable
					);

					parentThis.handleDelete();
					parentThis.handleCheckbox();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		// Student : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

	}

})(jQuery);