/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elAccount: '.select-account',
		elFromDate: '.fromdate',
		elToDate: '.todate',

		urlRequestData: window.APP.siteUrl + 'adm/report_general_ledgers/get_data_detail',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					account: '',
					fromdate: '',
					todate: '',
					date: '',
					grand_total_credit: 0,
					grand_total_debit: 0,
					total_transaksi: 0,
					detailData: []
				},
				methods: {
					getData: function () {
						var vue          = this;
						var val_account  = $(that.elAccount).val();
						var val_fromdate = $(that.elFromDate).val();
						var val_todate   = $(that.elToDate).val();

						var text_account = $(that.elSupplier + ' option:selected').text();
						
						vue.$set(vue, 'account', text_account);

						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'account' : val_account,
								'fromdate': val_fromdate,
								'todate'  : val_todate
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {
								vue.$set(vue, 'detailData', response['detail_data']);
								vue.$set(vue, 'grand_total_debit', response['grand_total_debit']);
								vue.$set(vue, 'grand_total_credit', response['grand_total_credit']);
								vue.$set(vue, 'total_transaksi', response['total_transaksi']);
								vue.$set(vue, 'date', response['date']);
								
								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_general_ledgers/export_excel';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);