/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
		urlList: window.APP.siteUrl + 'adm/purchase_returns/get_embed',
        urlRequestDataDebt: window.APP.siteUrl + 'adm/purchase_returns/get_data_debt',
        urlRequestDataDebtEdit: window.APP.siteUrl + 'adm/purchase_returns/get_data_debt_edit',
        urlRequestDataEdit: window.APP.siteUrl + 'adm/purchase_returns/get_data_detail_edit',
        urlRequestDataByFaktur: window.APP.siteUrl + 'adm/purchase_returns/get_data_detail_by_faktur',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					detailDataDebt: [],
					byPO: false,
					ppn_id: '',
					returTotal: 0,
					ppn_amount: 0,
					debtsTotal: 0,
					cashTotal: 0
				},
				methods: {
					detailAdd: function () {
						// show modal
						var customer = $("#customer-select").val();

						if(customer == ""){
							toastr.warning('Silahkan pilih pelanggan terlebih dahulu!')
						}else{
							$(that.elModal).modal("show");
							$.ajax({
								url: that.urlList,
								success: function (response) {
									$(that.elModalC).html(response);
								}
							});
						}
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								ii.prop('checked', false);

							}, 100);
						}
					},
					
					handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();
                    	var trx_id = $("#trx_id").val();

                    	$.ajax({
                    		url: that.urlRequestDataEdit,
                    		type: 'post',
                    		data: {
                    			'id': id,
                    			'trx_id': trx_id,
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
					},

					handleNumber: function () {
						var vue = this;
						
						var trx_id = $("#purchase-select").val();

						$("#supplier-select").change(function (e) {
							var id = $(e.target).val();
							$.ajax({
								type: "POST",
								url: window.APP.siteUrl + 'adm/purchase_returns/get_number',
								dataType: "JSON",
								data: {
									id: id
								},
								success: function (data) {
									// $("#id").val(data['id']);
									$("#retur_number").val(data['autonumber']);
									$("#purchase-select").html("<option value=''>- Pilih -</option>");
									$.each(data['purch_data'], function(i, d) {
										if (id===d.pembelian_header_id) {
												$('#purchase-select').append('<option value="' + d.pembelian_header_id + '" selected="selected">' + d.pembelian_header_number + '</option>');
											}else{
												$('#purchase-select').append('<option value="' + d.pembelian_header_id + '">' + d.pembelian_header_number + '</option>');
											}
									});									
								},
							});	
							
							$.ajax({
								url: that.urlRequestDataDebt,
								type: 'post',
								data: {
									'id': trx_id,
									'supplier': id
								},
								dataType: "json",
								beforeSend: function () {
									$(that.elVue).block({
										message: '<h4>Please Wait..</h4>'
									});
								},
								success: function (response) {
									vue.$set(vue, 'detailDataDebt', response);
									$(that.elVue).unblock();
								}
							});
						});
					},

					handleItemByFaktur: function() {
						var vue = this;

						var previousValue;
						$("#purchase-select").on('focus', function (e) {
							previousValue = this.value;
						}).change(function () {
							var id_faktur = $(this).val();
							var storedPreviousValue = previousValue;
							
							if (vue.detailData.length > 0) {

								Swal.fire({
									title: 'Anda yakin ingin mengganti Supplier?',
									text: "Data item akan direset",
									type: 'warning',
									showCancelButton: true,
									confirmButtonColor: '#3085d6',
									cancelButtonColor: '#d33',
									confirmButtonText: 'Ya, Lanjut!',
									cancelButtonText: 'Batal'
								}).then((result) => {
									if (result.value) {
										vue.detailData.splice(0, vue.detailData.length);

										$.ajax({
											url: that.urlRequestDataByFaktur,
											type: 'post',
											data: {
												'id': id_faktur,
											},
											dataType: "json",
											beforeSend: function () {
												$(that.elVue).block({
													message: '<h4>Please Wait..</h4>'
												});
											},
											success: function (response) {
												vue.$set(vue, 'detailData', response);
												$(that.elVue).unblock();
											}
										});

									} else if (result.dismiss == 'cancel') {
										
										if (previousValue != undefined) {
											$("#purchase-select").val(storedPreviousValue).trigger('change.select2');
										}
										previousValue = storedPreviousValue;
									}
								})

							}else{

								Swal.fire({
									title: 'Ambil data dari Faktur?',
									text: "Data item akan diisi otomatis berdasarkan Nomor Pembelian",
									type: 'warning',
									showCancelButton: true,
									confirmButtonColor: '#3085d6',
									cancelButtonColor: '#d33',
									confirmButtonText: 'Ya, Lanjut!',
									cancelButtonText: 'Batal'
								}).then((result) => {
									if (result.value) {
										$.ajax({
											url: that.urlRequestDataByFaktur,
											type: 'post',
											data: {
												'id': id_faktur,
											},
											dataType: "json",
											beforeSend: function () {
												$(that.elVue).block({
													message: '<h4>Please Wait..</h4>'
												});
											},
											success: function (response) {
												vue.$set(vue, 'detailData', response);
												$(that.elVue).unblock();
											}
										});	
									} else if (result.dismiss == 'cancel') {
										vue.detailData.splice(0, vue.detailData.length);
									}
								})

							}

							previousValue = this.value;


							var supp_id = $("#supplier-select").val();
							// console.log(supp_id);
										
							// if(id_faktur != ''){
								$.ajax({
									url: that.urlRequestDataDebt,
									type: 'post',
									data: {
										'id': id_faktur,
										'supplier': supp_id
									},
									dataType: "json",
									beforeSend: function () {
										$(that.elVue).block({
											message: '<h4>Please Wait..</h4>'
										});
									},
									success: function (response) {
										vue.$set(vue, 'detailDataDebt', response);
										// console.log("EHEHE");
										$(that.elVue).unblock();
									}
								});
							// }

						});

						
                    	
					},

					handlePrice: function(row, field_name, value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						
						vue.$set(row, field_name, value);
						vue.handleCount(row, field_name, value);
					},

					handleBayar: function(row, field_name, value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);

						vue.$set(row, field_name, value);
						// setTimeout(function () {
						vue.handleCheckBayar(row, field_name, value);
						// }, 100);
					},

					handleCheckBayar: function(row, field_name, value) {
						var vue = this;

						let a = row.total_bayar.replace(/[^\w\s]/gi, '');
						let b = row.total.replace(/[^\w\s]/gi, '');
						// console.log("bayar: " +parseInt(a));
						// console.log("total: " +parseInt(b));
						if(parseInt(a) > parseInt(b)){
							toastr.warning('Pembayaran melebihi Total Hutang!');
							vue.$set(row, 'total_bayar', row.total);
							// console.log('Melebihi');
						}

						
						// console.log(value);
					},
					
					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;
						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);
							vue.handleStock(row, field_name, value);
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							vue.handleStock(row, field_name, value);
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
							vue.handleStock(row, field_name, value);
						}

						// result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						// result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						// result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						
				// 		total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));
				// 		var ppn_total = 0
				// 		if(row.ppn_status == "2"){
							// ppn_total = (total * 0.10);
				// 			var ppn_amount = $("#ppn_amount").val();
				// 			    ppn_total  = (total * (ppn_amount/100));
				// 		}
						console.log(ppn_total);
						console.log(total);
				// 		console.log(total + ppn_total);
				// 		vue.$set(row, 'ppn_total', ppn_total);
				// 		vue.$set(row, 'total', (total + ppn_total).toLocaleString("en-US"));
				        vue.$set(row, 'total', (total).toLocaleString("en-US"));
						console.log(row);
				// 		vue.$set(row, 'total', total.toLocaleString("en-US"));

						// console.log(row.result_large);
						// console.log(row.result_medium);
						// console.log(row.result_small);
						// console.log(row.total);


						// discount = total * row.discount / 100;
						// sub_total = total - discount;
						// vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						// vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));
						// vue.$set(row, field_name, value);
					},
					countPPNTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].ppn_total);
						}

						return totalAmmount.toLocaleString("en-US");
					},

					handleStock: function(row, field_name, value) {
						var vue = this;

						lg_calc = 0;
						md_calc = 0;
						sm_calc = 0;

						calc = row.total_stock_stored;
						calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

						if(calc < 0){
							toastr.warning('Retur melebihi stok!');
							if(field_name == 'lg_unit_qty'){
								vue.$set(row, 'lg_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'md_unit_qty'){
								vue.$set(row, 'md_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'sm_unit_qty'){
								vue.$set(row, 'sm_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
						}
						
						vue.$set(row, 'total_stock', calc);
					},

					countSubTotal: function () {
						var vue = this;
                        var ppnTotal = 0;
						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							var total = parseFloat(items[i].total);
							if(total > 0){
								total = parseFloat(items[i].total.replace(/,/g, ''));
							}
							totalAmmount += total;
						}
						
                	   if(vue.ppn_id == true){
							ppnTotal = totalAmmount * (vue.ppn_amount/100);
							vue.returTotal = totalAmmount + ppnTotal;
			
			
						}else{
							ppnTotal = 0;
							vue.returTotal = totalAmmount + ppnTotal;
				
						}
						if ($("#ppn_id").val() == "1") {
							$("#ppn_id").val("1");
						}else{
							$("#ppn_id").val("0");
						}
	                    $("#ppn_total").val(ppnTotal.toLocaleString("en-US"));
                	    console.log(vue.ppn_amount);
				// 		vue.returTotal = totalAmmount;
						vue.handleDisableSave();
						return (totalAmmount + + ppnTotal).toLocaleString("en-US");
					},

					countTotalPaid: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailDataDebt;
						// console.log(items);
						for (var i in items) {
							var total = parseFloat(items[i].total_bayar);
							if(total > 0){
								total = parseFloat(items[i].total_bayar.replace(/,/g, ''));
							}
							totalAmmount += total;
						}
						

						vue.debtsTotal = totalAmmount;
						vue.handleDisableSave();
						return totalAmmount.toLocaleString("en-US");
					},

					countTotalTunai: function () {
						var vue = this;

						var result = 0;
						var totalRetur = 0;
						var itemsRetur = vue.detailData;
						var id = $("#id").val();
						
						for (var i in itemsRetur) {
							var total = parseFloat(itemsRetur[i].total);
							if(total > 0){
								total = parseFloat(itemsRetur[i].total.replace(/,/g, ''));
							}
							totalRetur += total;
						}

						var totalDebt = 0;
						var itemsDebt = vue.detailDataDebt;
						for (var i in itemsDebt) {
							var total = parseFloat(itemsDebt[i].total_bayar);
							if(total > 0){
								total = parseFloat(itemsDebt[i].total_bayar.replace(/,/g, ''));
							}
							totalDebt += total;
						}
						
						if(vue.ppn_id == true){
							ppnTotal = totalRetur * (vue.ppn_amount/100);
							result = (totalRetur - totalDebt) + ppnTotal; 
			
			
						}else{
							ppnTotal = 0;
					    	result = (totalRetur - totalDebt) + ppnTotal; 
				
						}
	                    $("#ppn_total").val(ppnTotal.toLocaleString("en-US"));
                	    console.log(vue.ppn_amount);
					
				// 		result = (totalRetur - totalDebt); 
						return result.toLocaleString("en-US");
					},
					handleCheckboxPPN: function () {
						var vue = this;
						// var a = $("#ppn_id").val();
						
						vue.countTotalTunai();
					},

					countTunaiPaid: function(value) {
						var vue = this;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						
						vue.handleDisableSave();
						vue.cashTotal = value;
						// console.log(vue.TunaiPaid);
					},

					handleDisableSave: function() {
						var vue = this;
						
						var result = false;

						var retur = vue.returTotal;
						var debts = vue.debtsTotal;
						var cash = vue.cashTotal;
						var ppn = vue.ppn_total;

						var cash_fix = (cash.toString().length > 4 ? cash.replace(/,/g, '') : cash);

						var paid = (Number(cash_fix) + Number(debts) + Number(ppn));
						result = retur < paid ? true : false;

						return result;
					},

					handleForm2: function () {
						var vue = this;
			
						window.DATETIME.initDatePicker();
			
						$(that.elForm).validate();
			
						$(that.elForm).ajaxForm({
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
			
								if (vue.detailData.length == 0) {
									toastr.warning('Silahkan isi data terlebih dahulu!')
									$(that.elVue).unblock();
									return false;
								}
							},
							data: {
								vuedata: vue.detailData,
								db_vuedata: vue.detailDataDebt
							},
							dataType: "json",
							success: function (response) {
								$(that.elVue).unblock();

								window.FORM.showNotification(response.message, response.status);

								if (response.status == "success") {
									setTimeout(function () {
										window.location.href = window.APP.siteUrl + 'adm/purchase_returns/'
									}, 1500);
								}
			
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
					
				// 	$.ajax({
				// 		url: window.APP.siteUrl + 'adm/purchase_returns/get_data_ppn',
				// 		success: function (response) {
				// 			vue.$set(vue, 'ppn_amount', response);
				// 		}
				// 	});
				
					
					vue.handleData();
					vue.handleNumber();
					vue.handleItemByFaktur();
					vue.countPPNTotal();
					
					setTimeout(function () {
						that.handleForm();
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);
						$.ajax({
                    		url: window.APP.siteUrl + 'adm/purchase_returns/get_data_ppn',
    						type: 'post',
                    		data: {
                    			'id': id
                    		},
    						dataType: "json",
                    		success: function (response) {
    							vue.$set(vue, 'ppn_amount', response);
    							console.log(response);
                    		}
                	    });
						var ppn_id = $("#ppn_id").val();
						if(ppn_id == "1"){
							$("#ppn_id").attr("checked", true);
							vue.$set(vue, 'ppn_id', true);
						}else{
							$("#ppn_id").attr("checked", false);
							vue.$set(vue, 'ppn_id', false);
						}
						
						if(id != "new")
						that.handleEdit();

					}, 500);
				}
			});

		},

		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();
			
			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData,
					db_vuedata: that.initVue.detailDataDebt
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					if (response.status == "success") {
						setTimeout(function () {
							window.location.href = window.APP.siteUrl + 'adm/purchase_returns/';
						}, 1500);
					}

				}
			});

        },

		handleEdit: function () {
			var that = this;
			
			var sup_id = $("#supplier-select").val();
			var po_id = $("#trx-id").val();
			var id = $("#id").val();

			$.ajax({
				type    : "POST",
				url     : window.APP.siteUrl + 'adm/purchase_returns/get_number',
				dataType: "JSON",
				data    : {
					id: sup_id
				},
				success: function (data) {
					// $("#id").val(data['id']);
					// $("#retur_number").val(data['retur_number']);
					$("#purchase-select").html("<option value=''>- Pilih -</option>");
					$.each(data['purch_data'], function(i, d) {
						if (po_id===d.pembelian_header_id) {
								$('#purchase-select').append('<option value="' + d.pembelian_header_id + '" selected="selected">' + d.pembelian_header_number + '</option>');
							}else{
								$('#purchase-select').append('<option value="' + d.pembelian_header_id + '">' + d.pembelian_header_number + '</option>');
							}
					});									
				},
			});	
				
			$.ajax({
				url: that.urlRequestDataDebtEdit,
				type: 'post',
				data: {
					'id': id,
					'po_id': po_id,
					'supplier': sup_id
				},
				dataType: "json",
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});
				},
				success: function (response) {
					that.initVue.$set(that.initVue, 'detailDataDebt', response);
					$(that.elVue).unblock();
				}
			});
		},
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);