/**
 * Javascript Items
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.MASTER = (function ($) {

	var renderCheckbox = function (data, type, full, meta) {
		return '<input class="check-sub-master" type="checkbox" value="' + full['id'] + '">';
	}

	var renderEdit = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/items/edit/' + full['id'];
		return '<a class="master-edit" href="' + url + '" data-toggle="tooltip" data-placement="right" title="Click to Edit">' + data + '</a>';
	}
	
	var renderEditHargaBeli = function (data, type, full, meta) {
// 		var url = APP.siteUrl + 'adm/items/edit/' + full['id'];
		return '<input type="text" class="edit_harga_beli" value="' + data + '"/>';
	}

	var renderGroupPrice = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/group_prices/edit/' + full['id'];
		return '<a href="'+ url +'" class="btn btn-sm btn-secondary" data-toggle="tooltip" data-placement="right" title="Click to Edit Group Prices"><i class="fas fa-user-circle"></i></a>';
	}

	var renderPrice = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/wholesale_prices/edit/' + full['id'];
		return '<a href="'+ url +'" class="btn btn-sm btn-warning" data-toggle="tooltip" data-placement="right" title="Click to Edit Wholesale Prices"><i class="fas fa-book"></i></a>';
	}

	var renderPhone = function (data, type, full, meta) {
		var url = APP.siteUrl + 'adm/items/showon_mobile/' + full['id'];
		return '<a href="#" class="master-mobile btn btn-sm btn-outline-info ' +full['bgcolor']+'"style="width:110%" data-id="' + full['id'] + '" data-status="' + full['mobile_active'] + '" data-toggle="tooltip" data-placement="right" title="Show"><i class="fas fa-check"></i></a>';
	}

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elForm: '.master-form',
		elEdit: '.master-edit',
		elTable: '#master-table',
		elModal: '.master-modal',
		elBtnMobile: '.master-mobile',
		elBtnDelete: '.master-delete',
		elBtnOperational: '.master-operational',
		elModalClose: '.master-cancel',
		elSubCheckbox: '.check-sub-master',
		elParentCheckbox: '.check-all-master',
		elModalContent: '.master-modal-content',
		urlDeleteData: window.APP.siteUrl + 'adm/items/delete',
		urlShowOnMobile: window.APP.siteUrl + 'adm/items/show_item_on_mobile',
		urlOperational: window.APP.siteUrl + 'adm/items/set_operational',
		urlRequestData: window.APP.siteUrl + 'adm/items/get_data',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var parentThis = this;
		},

		// Master
		handleVueMaster: function () {
			var parentThis = this;

			// Vue Js
			new Vue({
				el: parentThis.elVue,
				delimiters: ['<%', '%>'],
				data: {
					operational: 0,
				},
				methods: {
					addRowType: function () {
						var vue = this;
					}
				},
				mounted: function () {
					parentThis.handleDataTable();
				}
			});

		},

		handleCheckbox: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elSubCheckbox, function () {
				var row     = ($('#master-table tr').length - 1);
				var checked = $('#master-table').find('input[class="check-sub-master"]:checked');

				if(row == checked.length){
					$('#check-all-master').prop('checked', true);
				}else{
					$('#check-all-master').prop('checked', false);
				}

			});

			$('select[name="master-table_length"]').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
				
			});

			$('#master-table_paginate').click(function(){
				if($(parentThis.elParentCheckbox).is(':checked')){
					$(parentThis.elSubCheckbox).prop('checked', true);
				}else{
					$(parentThis.elSubCheckbox).prop('checked', false);
				}
			});

		},
		
		// Items : handleDataTable
		handleDataTable: function () {
			var parentThis = this;

			// Datatable
			parentThis.elDatatable = $(parentThis.elTable).DataTable({
				ajax: {
					url: parentThis.urlRequestData
				},
				columns: [{
						data: 'no',
						width: '20',
						render: renderCheckbox
					},
					{
						data: 'name',
						render: renderEdit,
					},
					{
						data: 'grup',
					},
					{
						data: 'grup_child',
					},
						{
						data: 'stok_gd1',
					},
					{
						data: 'stok_gd2',
					},
					{
						data: 'stok_gd3',
					},
					{
						data: 'unit',
					},
					{
						data: 'harga_beli',
				// 		render: renderEditHargaBeli,
					},
					{
						data: 'harga_jual',
					},
					{
						data: 'minimum_stock',
						className: 'fit-width',
					},
					{
						data: 'ppn_status',
						className: 'fit-width',
					},
					{
						className: 'fit-width',
						render: renderGroupPrice,
					},
					{
						className: 'fit-width',
						render: renderPrice,
					},
					{
						className: 'fit-width',
						render: renderPhone,
					},
				],

				order: [],
				deferRender: true,
				scrollX: true,
				"columnDefs": [{
					"targets": [0,7,8,9,10,11],
					"orderable": false,
				}],
				"language": {
					"url": parentThis.urlBahasa,
					"sEmptyTable": "Tidads"
				},

				initComplete: function () {

					// handle form
					window.FORM.handleEditModal(
						parentThis.elForm,
						parentThis.elEdit,
						parentThis.elModal,
						parentThis.elModalContent,
						parentThis.elModalClose,
						parentThis.elDatatable
					);

					parentThis.handleDelete();
					parentThis.handleOperational();
					parentThis.handleCheckbox();
					parentThis.handleMobileIsActive();
					window.INPUT.handleCheckboxAll(parentThis.elParentCheckbox, parentThis.elSubCheckbox);
				}

			});
		},

		// Items : handleDelete
		handleDelete: function () {
			var parentThis = this;

			$(parentThis.elBtnDelete).click(function () {

				var Items = $(parentThis.elTable).find('input[class="check-sub-master"]:checked');

				var types = [];
				for (var i = 0; i < Items.length; i++) {
					types.push($(Items[i]).val());
				}

				if (!types.length) {

					toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')

					return false;

				} else {

					Swal.fire({
						title: 'Anda yakin?',
						text: "Ingin menghapus data ini?",
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#3085d6',
						cancelButtonColor: '#d33',
						confirmButtonText: 'Ya, Hapus!',
						cancelButtonText: 'Batal'
					}).then((result) => {
						if (result.value) {
							$.ajax({
								type: "POST",
								dataType: 'json',
								url: parentThis.urlDeleteData,
								data: {
									id: types,
								},
								success: function (response) {
									window.FORM.showNotification(response.message, response.status);
									parentThis.elDatatable.ajax.reload();

									$('input[type="checkbox"]').prop('checked', false);
								}
							});
						}
					})


				}
			});
		},

		handleOperational: function () {
			var parentThis = this;

			$(parentThis.elBtnOperational).click(function (e) {
				var id = $(e.target).val();
				Swal.fire({
					title: 'Anda yakin?',
					text: "Ingin mengubah status barang?",
					type: 'warning',
					showCancelButton: true,
					confirmButtonColor: '#3085d6',
					cancelButtonColor: '#d33',
					confirmButtonText: 'Ya, Hapus!',
					cancelButtonText: 'Batal'
				}).then((result) => {
					if (result.value) {
						$.ajax({
							type: "POST",
							dataType: 'json',
							url: parentThis.urlOperational,
							data: {
								id: id,
							},
							success: function (response) {
								window.FORM.showNotification(response.message, response.status);
								parentThis.elDatatable.ajax.reload();

								// $('input[type="checkbox"]').prop('checked', false);
							}
						});
					}
				})

			});
		},

		handleMobileIsActive: function () {
			var parentThis = this;

			$(parentThis.elTable).on("click", parentThis.elBtnMobile, function () {
				var id = $(this).attr('data-id');
				var data = $(this).attr('data-status');
				
				$.ajax({
					type: "POST",
					dataType: 'json',
					url: parentThis.urlShowOnMobile,
					data: {
						id: id,
						data: data
					},
					success: function (response) {
						window.FORM.showNotification(response.message, response.status);
						parentThis.elDatatable.ajax.reload();
					}
				});
			});
		},

		getGroupChild: function(id, gcid) {
			var parentThis = this;

			$.ajax({
				type: "POST",
				url: window.APP.siteUrl + 'adm/items/get_data_group_child',
				dataType: "JSON",
				data: {
					id: id
				},
				success: function (data) {

					$("#group-child-select").html("<option value=''>- Pilih -</option>");
					$.each(data, function (i, d) {
						if (gcid===d.group_child_id) {
							$('#group-child-select').append('<option value="' + d.group_child_id + '" selected="selected">' + d.group_child_name + '</option>');
						}else{
							$('#group-child-select').append('<option value="' + d.group_child_id + '">' + d.group_child_name + '</option>');
						}
					});

				},
			});
		},

		handleGroup: function () {
			var parentThis = this;

			$("#group-select").change(function (e) {
				var value = $(e.target).val();
				parentThis.getGroupChild(value);
			})
		},

		handleEditSelect: function () {
			var parentThis = this;
			var value = $("#gid").val();
			var value2 = $("#gcid").val();
			parentThis.getGroupChild(value, value2);
		}

	}

})(jQuery);