<?php
/**
 * Point Requirements Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Ptsreqs_model extends Model {

	public function ptsreq_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('ptsreq_headers a');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function ptsreq_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('ptsreq_details a');
	    $sql->join('master_items b', 'b.item_id = a.ptsreq_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function ptsreq_advance($where='', $period= '', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('ptsreq_headers a');
	    $sql->join('ptsreq_details b', 'b.ptsreq_detail_header_id = a.ptsreq_header_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($period != '') {
			$sql->where('"'.$period.'" BETWEEN ptsreq_header_period_start and ptsreq_header_period_end');
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('ptsreq_headers', $data);
		}

		return $this->db->insert('ptsreq_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('ptsreq_details', $data);
		}

		return $this->db->insert('ptsreq_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('ptsreq_header_id', $id);
		return $this->db->update('ptsreq_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("ptsreq_header_id", $id);
		return $this->db->delete("ptsreq_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("ptsreq_detail_header_id", $id);
		return $this->db->delete("ptsreq_details");
	}

}

?>
