<?php
/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Penerimaan_model extends Model {

	public function purchaseorder_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(penerimaan_headers.penerimaan_header_number, 4) as serial_number', FALSE);
		$sql->where('MONTH(penerimaan_header_date) = MONTH(CURRENT_DATE())');
		$sql->where('YEAR(penerimaan_header_date) = YEAR(CURRENT_DATE())');
		// $sql->where('SUBSTR(penerimaan_headers.penerimaan_header_number, 1, 2) = "'.$supp_code.'"');
		$sql->order_by('penerimaan_header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('penerimaan_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}
	public function purchaseorder_header_available($where = '', $order = '')
    {
    $sql = $this->db;
    
    $sql->select('*, a.timestamp as tmstamp_po');
    $sql->from('penerimaan_headers a');
    $sql->join('master_suppliers b', 'b.supplier_id = a.penerimaan_header_customer_id', 'inner');
    
    // LEFT JOIN pembelian_headers and check if matching record is NULL (not linked)
    $sql->join('pembelian_headers c', 'c.pembelian_header_penerimaan_id = a.penerimaan_header_id', 'left');
    $sql->where('c.pembelian_header_id IS NULL'); // filter only unlinked records
    
    if ($where != '') {
        $sql->where($where);
    }
    
    if ($order != '') {
        $sql->order_by($order);
    }
    
    $get = $sql->get();
    
    return $get;
    }

	public function purchaseorder_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*, , a.timestamp as tmstamp_po');
		$sql->from('penerimaan_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.penerimaan_header_customer_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('penerimaan_details a');
	    $sql->join('master_items b', 'b.item_id = a.penerimaan_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail2($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('penerimaan_details a');
	    $sql->join('master_items b', 'b.item_id = a.penerimaan_detail_item_id', 'left');
	    $sql->join('master_groups c', 'c.group_id = b.item_group_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_advance($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('penerimaan_details a');
	    $sql->join('penerimaan_headers b', 'b.penerimaan_header_id = a.penerimaan_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.penerimaan_detail_item_id', 'left');
	    $sql->join('master_suppliers d', 'd.supplier_id = b.penerimaan_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_sum($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*, sum(penerimaan_detail_result_large + penerimaan_detail_result_medium + penerimaan_detail_result_small) as result');
	    $sql->from('penerimaan_details a');
	    $sql->join('penerimaan_headers b', 'b.penerimaan_header_id = a.penerimaan_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.penerimaan_detail_item_id', 'left');
	    $sql->join('master_suppliers d', 'd.supplier_id = b.penerimaan_header_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_headersearch($type='', $supplier='', $search='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('penerimaan_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.penerimaan_header_customer_id', 'inner');

    	if ($search != '')
		{
			$sql->like('penerimaan_header_number', $search);
			$sql->or_like('penerimaan_header_date', $search);
		}

		$sql->where('penerimaan_header_customer_id', $supplier);
		$sql->where('status_paid', 0);
		$sql->order_by('penerimaan_header_date asc');

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('penerimaan_headers', $data);
		}

		return $this->db->insert('penerimaan_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('penerimaan_details', $data);
		}

		return $this->db->insert('penerimaan_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('penerimaan_header_id', $id);
		return $this->db->update('penerimaan_headers', $data);
	}

	public function update_item_batch($data) {
		// $this->db->where('log_id', $where);
		return $this->db->update_batch('logs', $data, 'log_id');
	}

	public function update_master_item_batch($data) {
		return $this->db->update_batch('master_items', $data, 'item_id');
	}

	public function delete_header($id)
	{
		$this->db->where("penerimaan_header_id", $id);
		return $this->db->delete("penerimaan_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("penerimaan_detail_header_id", $id);
		return $this->db->delete("penerimaan_details");
	}

	public function delete_detail_advance($where)
	{
		$this->db->where($where);
		return $this->db->delete("penerimaan_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("penerimaan_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("penerimaan_details");
	}

}
