<?php

/**
 * Credits Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Credits_model extends Model
{

	public function credit_header_lite($where = '')
	{
		$sql = $this->db;

		$sql->select('credit_headers.credit_header_id as id');
		$sql->from('credit_headers');

		if ($where != '') {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function salesorder_headersearch($type = '', $customer = '', $search = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('sales_order_headers a');
		$sql->join('master_customers b', 'b.customer_id = a.sales_order_header_customer_id', 'left');

		if ($search != '') {
            $sql->group_start();
            $sql->like('sales_order_header_number', $search);
            $sql->or_like('sales_order_header_date', $search);
            $sql->or_like('customer_name', $search);
            $sql->group_end();
        }

// 		$sql->where('sales_order_header_customer_id', $customer);
		// $sql->where('status_paid', 0);
		$sql->where('sales_order_header_payment_method', 'Kredit');
		$sql->where('is_hold', 0);
        $sql->order_by('customer_name ASC');

		$get = $sql->get();

		return $get;
	}
	
	public function salesorder_headersearch_credit($type = '', $customer = '', $search = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('sales_order_headers a');
		$sql->join('master_customers b', 'b.customer_id = a.sales_order_header_customer_id', 'left');

		if ($search != '') {
            $sql->group_start();
            $sql->like('sales_order_header_number', $search);
            $sql->or_like('sales_order_header_date', $search);
            $sql->or_like('customer_name', $search);
            $sql->group_end();
        }

		$sql->where('sales_order_header_customer_id', $customer);
		// $sql->where('status_paid', 0);
		$sql->where('sales_order_header_payment_method', 'Kredit');
		$sql->where('is_hold', 0);
        $sql->order_by('customer_name ASC');

		$get = $sql->get();

		return $get;
	}

	public function get_sum_retur($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(a.sales_return_header_total_tunai) as total_retur');
		$sql->from('sales_return_headers a');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_sum_telah_bayar($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('a.*, b.credit_header_retur_id, SUM(a.credit_detail_bayar) as total_telah_bayar, SUM(a.credit_detail_discount_total) as total_disc,SUM(a.credit_detail_deposit) as total_deposit');
		$sql->from('credit_details a');
		$sql->join('credit_headers b', 'b.credit_header_id = a.credit_detail_header_id', 'inner');


		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function credit_autonumber()
	{
		$sql = $this->db;

		$sql->select('RIGHT(credit_headers.credit_header_number, 4) as serial_number', FALSE);
// 		$sql->where('MONTH(credit_header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('credit_header_number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('credit_headers');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 01;
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function credit_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_headers a');
		$sql->join('master_customers b', 'b.customer_id = a.credit_header_customer_id', 'inner');
		$sql->join('master_banks c', 'c.bank_id = a.credit_header_bank_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function credit_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_details a');
		$sql->join('sales_order_headers b', 'b.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');
		$sql->join('master_customers c', 'c.customer_id = a.credit_detail_sales_customer_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function credit_details2($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_details2 a');
		$sql->join('sales_order_headers b', 'b.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');
		$sql->join('master_customers c', 'c.customer_id = a.credit_detail_sales_customer_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	public function credit_detail_deposit($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_details a');
		$sql->join('sales_order_headers b', 'b.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');
		$sql->join('master_customers c', 'c.customer_id = a.credit_detail_sales_customer_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}
		
		$sql->where('credit_detail_bayar > credit_detail_total', NULL, FALSE);
		$sql->where('a.credit_detail_sales_order_header_id NOT IN (SELECT credit_detail_deposit_sales_id FROM credit_details)', NULL, FALSE);

		$get = $sql->get();

		return $get;
	}
	
	public function credit_detail_deposit_edit($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_details a');
		$sql->join('sales_order_headers b', 'b.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');
		$sql->join('master_customers c', 'c.customer_id = a.credit_detail_sales_customer_id', 'inner');
		$sql->join('credit_headers d', 'd.credit_header_id = a.credit_detail_header_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}
		
		$sql->where('credit_detail_bayar > credit_detail_total', NULL, FALSE);
// 		$sql->where('a.credit_detail_sales_order_header_id NOT IN (SELECT credit_detail_deposit_sales_id FROM credit_details)', NULL, FALSE);

		$get = $sql->get();

		return $get;
	}
	
	public function credit_detail_deposit_laporan($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_details a');
		$sql->join('sales_order_headers b', 'b.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');
		$sql->join('master_customers c', 'c.customer_id = a.credit_detail_sales_customer_id', 'inner');
		$sql->join('credit_headers d', 'd.credit_header_id = a.credit_detail_header_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}
		
		$sql->where('credit_detail_bayar > credit_detail_total', NULL, FALSE);
		$sql->where('a.credit_detail_sales_order_header_id NOT IN (SELECT credit_detail_deposit_sales_id FROM credit_details)', NULL, FALSE);
// 		$sql->where('a.credit_detail_sales_order_header_id NOT IN (SELECT credit_detail_deposit_sales_id FROM credit_details)', NULL, FALSE);

		$get = $sql->get();

		return $get;
	}
	public function credit_detail_advanced($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_details a');
		$sql->join('credit_headers b', 'b.credit_header_id = a.credit_detail_header_id', 'left');
		$sql->join('sales_order_headers c', 'c.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');
		$sql->join('master_customers d', 'd.customer_id = a.credit_detail_sales_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function credit_detail_advanced_history($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_details a');
		$sql->join('credit_headers b', 'b.credit_header_id = a.credit_detail_header_id', 'left');
		$sql->join('sales_order_headers c', 'c.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');
		$sql->join('master_customers d', 'd.customer_id = c.sales_order_header_customer_id', 'left');
		$sql->join('sales_return_headers e', 'e.sales_return_header_id  = b.credit_header_retur_id', 'left');
		$sql->join('master_accounts f', 'f.account_id  = b.credit_header_account_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('credit_headers', $data);
		}

		return $this->db->insert('credit_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('credit_details', $data);
		}

		return $this->db->insert('credit_details', $data);
	}
		public function save_detail2($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('credit_details2', $data);
		}

		return $this->db->insert('credit_details2', $data);
	}
	
	public function save_dump($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('transactionTbl', $data);
		}

		return $this->db->insert('transactionTbl', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('credit_header_id', $id);
		return $this->db->update('credit_headers', $data);
	}

	public function delete_headerbyretur($id)
	{
		$this->db->where("credit_header_retur_id", $id);
		return $this->db->delete("credit_headers");
	}

	public function delete_byretur($id)
	{
		$this->db->where("credit_detail_header_id", $id);
		return $this->db->delete("credit_details");
	}

	public function delete_header($id)
	{
		$this->db->where("credit_header_id", $id);
		return $this->db->delete("credit_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("credit_detail_header_id", $id);
		return $this->db->delete("credit_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("credit_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("credit_details");
	}
}
