<?php
/**
 * Sales Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Transfer extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		// $this->load->model('Sales_orders_model');
		$this->load->model('Transfer_model');
		$this->load->model('Warehouses_model');

		$this->load->model('Configuration_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
		$this->load->model('Logs_model');
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Special_prices_model');
		$this->load->model('Ptsreqs_model');
		$this->load->model('Log_points_model');
		$this->load->model('Users_model');
		$this->load->model('Ppn_model');
		$this->load->model('Group_prices_model');

		$this->load->model('Groups_model');
		$this->load->model('Units_model');
		$this->load->model('Users_model');

	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Transfer Barang';
		
		$this->twiggy_display('adm/transfer/index', $data);
	}
	
	public function get_details($id)
 	{	
        $data['content_title'] = 'Details';
        // $order = ("header_number ASC");
        $get_data = $this->Transfer_model->transfer_detail(array('header_id' => $id))->result();
        
        $data['history_data'] = $get_data;
        $data['id'] = $id;
		
		$this->twiggy_display('adm/transfer/detail', $data);
	}
	 
	public function get_data_header()
	{	
		$data = [];

		$get_data = $this->Transfer_model->transfer_header(array('gudang_from !=' => '0', 'gudang_to !=' => '0'), 'header_number desc')->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	

				$wr_from = $this->Warehouses_model->get_data(array('warehouse_id' => $get_row->gudang_from))->row();
				$wr_to   = $this->Warehouses_model->get_data(array('warehouse_id' => $get_row->gudang_to))->row();

				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->header_id,
					'number'      => $get_row->header_number,
					'date'        => indonesian_date($get_row->header_date),
					'wr_from'     => ($wr_from != "" ? $wr_from->warehouse_name : "Supplier"),
					'wr_to'       => ($wr_to != "" ? $wr_to->warehouse_name : "Pelanggan"),
					'description' => $get_row->header_description,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Transfer Barang";
		$header_data = array(null);

		$prefix  = "TF";
		$datenow = date('ym');
		$number_generator = $this->Transfer_model->transfer_autonumber();
		$autonumber ="";

		$date_text       = date_now();

	    if($id != 'new')
	    {
			$title       = "Edit Transfer Barang";
			$where       = array('header_id' => $id);
			$header_data = $this->Transfer_model->transfer_header($where)->row_array();
			$autonumber  = $header_data['header_number'];
			$date_text   = $header_data['header_date'];
		}

		$data['id']             = $id;
		$data['content_title']  = $title;
		$data['header_data']    = $header_data;
		$data['warehouse_data'] = $this->Warehouses_model->get_data()->result();

		
		$data['autonumber']  = $autonumber;
		$data['date_text']   = $date_text;

		$this->twiggy_display('adm/transfer/edit', $data);
	}

	public function get_data_detail()
	{	
		$id    = $this->input->post("id");
		$warehouse = $this->input->post('warehouse');
		$where = array('header_id' => $id);
		// $order = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Transfer_model->transfer_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		$no = 1;
		foreach($get_data as $get_row)
		{

			$in_stock = 0;
			$ou_stock = 0;
			$total_stock = 0;

			$get_stock_in = $this->Transfer_model->transfer_advance(array('gudang_to' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, gudang_to')->row();
			$get_stock_ou = $this->Transfer_model->transfer_advance(array('gudang_from' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, gudang_from')->row();

			if($get_stock_in){
				$in_stock = (($get_stock_in->large_qty * $get_row->large_unit_contain) + ($get_stock_in->medium_qty * $get_row->medium_unit_contain) + ($get_stock_in->small_qty * $get_row->small_unit_contain));
			}

			if($get_stock_ou){
				$ou_stock = (($get_stock_ou->large_qty * $get_row->large_unit_contain) + ($get_stock_ou->medium_qty * $get_row->medium_unit_contain) + ($get_stock_ou->small_qty * $get_row->small_unit_contain));
			}

			$total_stock = $in_stock - $ou_stock;

			$total_stock_stored = ($total_stock + (($get_row->lg_qty * $get_row->large_unit_contain) +
									($get_row->md_qty * $get_row->medium_unit_contain) +
									($get_row->sm_qty * $get_row->small_unit_contain)));
									
			$dsctype = 'B';
			// if($get_row->sales_order_detail_large_unit_discount > 0){
			// 	$dsctype = 'B';
			// }elseif($get_row->sales_order_detail_medium_unit_discount > 0){
			// 	$dsctype = 'S';
			// }else{
			// 	$dsctype = 'K';
			// }

			$therest      = $total_stock;
			$total_large  = ($get_row->large_unit_contain == 0 ? '0' : floor($total_stock / $get_row->large_unit_contain));
			$therest      = ($therest - ($total_large * $get_row->large_unit_contain));
			$total_medium = ($get_row->medium_unit_contain == 0 ? '0' : floor($therest / $get_row->medium_unit_contain));
			$therest      = ($therest - ($total_medium * $get_row->medium_unit_contain));
			$total_small  = ($get_row->small_unit_contain == 0 ? '0' : floor($therest / $get_row->small_unit_contain));
			$a = 0;
			$data[] = array(
				'no'                 => $no,
				'detail_id'          => $get_row->detail_id,
				'detail_header_id'   => $get_row->header_id,
				'id'                 => $get_row->item_id,
				'name'               => $get_row->item_name,
				'lg_unit'            => $get_row->large_unit,
				'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
				'lg_unit_qty'        => to_decimal($get_row->lg_qty),
				'lg_unit_qtys'        => to_decimal($get_row->lg_qty),
				'lg_unit_prc'        => number_format($get_row->lg_prc),
				'result_large'       => 0,
				'md_unit'            => $get_row->medium_unit,
				'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
				'md_unit_qty'        => to_decimal($get_row->md_qty),
				'md_unit_qtys'        => to_decimal($get_row->md_qty),
				'md_unit_prc'        => 0,
				'result_medium'      => 0,
				'sm_unit'            => $get_row->small_unit,
				'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
				'sm_unit_qty'        => to_decimal($get_row->sm_qty),
				'sm_unit_qtys'        => to_decimal($a),
				'sm_unit_prc'        => ($a),
				'result_small'       => $a,
				'ppn_status'         => $a,
				'ppn_status_color'   => $a,
				'total'              => ($a),
				'ppn_total'          => ($a),
				'total_stock'        => to_decimal($total_stock),
				'total_stock_stored' => to_decimal($total_stock_stored),
				'lg_unit_dsc'        => ($a),
				'md_unit_dsc'        => ($a),
				'sm_unit_dsc'        => ($a),
				'dsctype' => $a,
				'ttls_lg' => $a,
				'ttls_md' => $a,
				'ttls_sm' => $a,
			);
			$no++;
		}


		output_json($data);
	}

	public function get_embed()
	{
		$data = [];

		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/transfer/embed', $data);
	}

	public function get_data_embed()
	{
		$data     = [];
		$response = [];
		$search   = $this->input->post('search');
		$warehouse = $this->input->post('warehouse');


		$get_data = $this->Items_model->get_data_search($search)->result();
		$updateStock = $this->Items_model->updateStock();
                
                $updateStockGd1 = $this->Items_model->updateStockGd1();
                $updateStockGd2 = $this->Items_model->updateStockGd2();
                $updateStockGd3 = $this->Items_model->updateStockGd3();

		$no = 0;
		foreach($get_data as $get_row)
		{	
		    


			$large_unit_price  = $get_row->last_purchase_price_large_unit;
			$medium_unit_price = $get_row->last_purchase_price_medium_unit;
			$small_unit_price  = $get_row->last_purchase_price_small_unit;

			$in_stock = 0;
			$ou_stock = 0;
			$total_stock = 0;

			$get_stock_in = $this->Transfer_model->transfer_advance(array('gudang_to' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, gudang_to')->row();
			$get_stock_ou = $this->Transfer_model->transfer_advance(array('gudang_from' => $warehouse, 'item_id' => $get_row->item_id), 'item_id, gudang_from')->row();

			if($get_stock_in){
				$in_stock = (($get_stock_in->large_qty * $get_row->large_unit_contain) + ($get_stock_in->medium_qty * $get_row->medium_unit_contain) + ($get_stock_in->small_qty * $get_row->small_unit_contain));
			}

			if($get_stock_ou){
				$ou_stock = (($get_stock_ou->large_qty * $get_row->large_unit_contain) + ($get_stock_ou->medium_qty * $get_row->medium_unit_contain) + ($get_stock_ou->small_qty * $get_row->small_unit_contain));
			}

			$total_stock = $get_row->stok_pos;

			$ppn_status_color = "";
			if($get_row->ppn_status == '1'){
				$ppn_status_color = "";
			}elseif($get_row->ppn_status == '2'){
				$ppn_status_color = "bg-success";
			}else{
				$ppn_status_color = "bg-warning";
			}

			$bg_min_stock = "";
			$left_stock_large = 0;
			$left_stock_large = (to_decimal($total_stock)/to_decimal($get_row->large_unit_contain));
			if($left_stock_large <= to_decimal($get_row->minimum_stock)){
				$bg_min_stock = "bg-danger";
			}

			//
			$data[] = array(
					'no'                 => $no,
					'id'                 => $get_row->item_id,
					'name'               => $get_row->item_name,
					'group_id'           => $get_row->group_id,
					'group_name'         => $get_row->group_name,
					'group_child_id'     => $get_row->group_child_id,
					'group_child_name'   => $get_row->group_child_name,
					'lg_unit'            => $get_row->large_unit,
					'lg_unit_cnt'        => to_decimal($get_row->large_unit_contain),
					'lg_unit_prc'        => number_format($large_unit_price),
					'md_unit'            => $get_row->medium_unit,
					'md_unit_cnt'        => to_decimal($get_row->medium_unit_contain),
					'md_unit_prc'        => number_format($medium_unit_price),
					'sm_unit'            => $get_row->small_unit,
					'sm_unit_cnt'        => to_decimal($get_row->small_unit_contain),
					'sm_unit_prc'        => number_format($small_unit_price),
					'total_stock'        => to_decimal($total_stock),
					'total_stock_gd1'        => to_decimal($get_row->stok_pos_gd1),
					'total_stock_gd2'        => to_decimal($get_row->stok_pos_gd2),
					'total_stock_gd3'        => to_decimal($get_row->stok_pos_gd3),
					'total_stock_sedang_gd1'        => to_decimal($get_row->stok_pos_sedang_gd1),
					'total_stock_sedang_gd2'        => to_decimal($get_row->stok_pos_sedang_gd2),
					'total_stock_sedang_gd3'        => to_decimal($get_row->stok_pos_sedang_gd3),
					'total_stock_stored' => to_decimal($total_stock),
					'minimum_stock'      => to_decimal($get_row->minimum_stock),
					'bg_min_stock'       => $bg_min_stock,
					'ppn_total'          => 0,
					'ppn_status'         => $get_row->ppn_status,
					'ppn_status_color'   => $ppn_status_color,
					'lg_unit_hpp'        => ($get_row->large_unit_contain > 0 ? number_format($get_row->last_purchase_price_large_unit) : 0),
					'md_unit_hpp'        => ($get_row->medium_unit_contain > 0 ? number_format($get_row->last_purchase_price_medium_unit) : 0),
					'sm_unit_hpp'        => ($get_row->small_unit_contain > 0 ? number_format($get_row->last_purchase_price_small_unit) : 0),
					'btncolor'           => '',
					'btnicon'            => ''
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
		
	}

	public function save()
	{	
		date_default_timezone_set('Asia/Jakarta');

		$id     = $this->input->post('id');
		$number = $this->input->post("number");
		$date   = $this->input->post("date");
		$wrfrom = $this->input->post("wrfrom");
		$wrto   = $this->input->post("wrto");


		$btn_action = $this->input->post("btn_action");

		$user_id = logged_user('id');
		
		$vuedata = $this->input->post('vuedata');


		$header_id   = $id;
		$prefix  = "TF";
		$datenow = date('ym');
		$number_generator = $this->Transfer_model->transfer_autonumber();
		$autonumber = $prefix.$datenow.'-'.$number_generator;
		if($id == "new"){
		    $header_data = [
    			'header_number' => $autonumber,
    			'header_date'   => change_format_date($date),
    			'gudang_from'   => $wrfrom,
    			'gudang_to'     => $wrto
		    ];
		}else{
		    $header_data = [
    			'header_number' => $number,
    			'header_date'   => change_format_date($date),
    			'gudang_from'   => $wrfrom,
    			'gudang_to'     => $wrto
    		];
		}
		

		$detail_data = [];

		if(isset($id) && $id != '' && $id != NULL){
			if($vuedata){
				if($id == "new")
				{
					// save header
					$save_header = $this->Transfer_model->save_header($header_data);
					if($save_header)
					{
						$header_id = $this->db->insert_id();
						foreach($vuedata as $row)
						{
							$detail_data[] = [
								'header_id' => $header_id,
								'item_id'   => $row['id'],
								'lg_qty'    => trims($row['lg_unit_qty']),
								'md_qty'    => trims($row['md_unit_qty']),
								'sm_qty'    => trims($row['sm_unit_qty']),
								'lg_prc' => trims($row['lg_unit_prc']),
								'status'    => "TF",
							];
						}
						
						$save_detail = $this->Transfer_model->save_detail($detail_data, true);
						
						if($save_detail)
						{	
							$msg    = "Berhasil menyimpan data";
							$status = "success";
						}
						else
						{
							$msg    = "Gagal menyimpan data #DET-S01";
							$status = "error";	
						}
					}
					else
					{
						$msg    = "Gagal menyimpan data #HED-S01";
						$status = "error";	
					}
					
				}else{
					// This New Update
					$delete_detail = $this->Transfer_model->delete_detail($id);
	
					if ($delete_detail) {
						
						$save_header = $this->Transfer_model->update_header($id, $header_data);
	
						if($save_header)
						{
							// $header_id = $this->db->insert_id();
							foreach($vuedata as $row)
							{
								$detail_data[] = [
									'header_id' => $header_id,
									'item_id'   => $row['id'],
									'lg_qty'    => trims($row['lg_unit_qty']),
									'md_qty'    => trims($row['md_unit_qty']),
									'sm_qty'    => trims($row['sm_unit_qty']),
									'lg_prc' => trims($row['lg_unit_prc']),
									'status'    => "TF",
								];
								
							}
	
							$save_detail = $this->Transfer_model->save_detail($detail_data, true);
	
							if($save_detail)
							{
								$msg    = "Berhasil menyimpan data";
								$status = "success";
							}
							else
							{
								$msg    = "Gagal menyimpan data #LOG-U01";
								$status = "error";	
							}
						}
						else{
							$msg    = "Gagal menyimpan data #HED-U01";
							$status = "error";
						}
	
					}
					else{
						$msg    = "Gagal menyimpan data #DEL-U01";
						$status = "error";
					}
				}
			}else{
				$msg    = "Gagal menyimpan data, detail tidak terbaca.";
				$status = "error";
			}
		}else{
			$msg    = "Gagal menyimpan data, id tidak terbaca.";
			$status = "error";
		}

		$response = [
			'message'    => $msg,
			'status'     => $status,
			'id'         => $header_id,
			'btn_action' => $btn_action
		];
		output_json($response);

	}

	public function update_log($vuedata, $header_id='', $date='')
	{	
		$data_log = [];
		$data_where = [];

		$updateData = array();

		$total_stok = 0;
		$total_stok_rupiah = 0;
		$avg_lg = 0;
		$avg_md = 0;
		$avg_sm = 0;

		foreach($vuedata as $rowes)
		{
			
			$where_1         = array('log_item_id' => $rowes['id']);
			$get_first       = $this->Logs_model->get_data_first($where_1)->row();
			$logs_id         = $get_first->tmslog;

			$total_stok      = $get_first->log_total_stock;
			$total_stok_rupiah = $get_first->log_total_stock_value;

			$avg_lg  = ($get_first->log_average_large_unit);
			$avg_md  = ($get_first->log_average_medium_unit);
			$avg_sm  = ($get_first->log_average_small_unit);

			$log_total_transaction_value = 0;
		
			$where_2 = array('log_item_id' => $rowes['id'], 'a.timestamp >' => $logs_id);
			$get_data_all_logs_by_item = $this->Logs_model->get_data($where_2, 'a.timestamp asc')->result();

			foreach ($get_data_all_logs_by_item as $row) {


				$total_stok      += $row->log_total_transaction_in_small_unit;
				
				if($row->log_type == "BUY" || $row->log_type == "R-SELL"){
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($row->log_large_unit_purchase_price)) + ($row->log_medium_unit_quantity * ($row->log_medium_unit_purchase_price)) + ($row->log_small_unit_quantity * ($row->log_medium_unit_purchase_price)));
				}else{
					$log_total_transaction_value = (($row->log_large_unit_quantity * ($avg_lg)) + ($row->log_medium_unit_quantity * ($avg_md)) + ($row->log_small_unit_quantity * ($avg_sm)));
				}
				$total_stok_rupiah += $log_total_transaction_value;
				

				$log_average_small_unit  = ($total_stok == 0 ? 0 : ($total_stok_rupiah / $total_stok));
				$log_average_medium_unit = ($log_average_small_unit * $row->medium_unit_contain);
				$log_average_large_unit  = ($log_average_small_unit * $row->large_unit_contain);

				// $log_total_transaction_value = a;

				if($row->log_type == "BUY" || $row->log_type == "R-SELL"){
					$avg_lg  = ($log_average_large_unit);
					$avg_md  = ($log_average_medium_unit);
					$avg_sm  = ($log_average_small_unit);
					$data_log[] = array(
						'log_id'                        => $row->log_id,
						// 'log_medium_unit_purchase_price' => $medium_purchase_price,
						// 'log_small_unit_purchase_price'  => $small_purchase_price,
						// 'log_total_transaction_value' => $log_total_transaction_value,
						'log_total_stock'             => $total_stok,
						'log_total_stock_value'       => $total_stok_rupiah,
						'log_average_large_unit'      => $log_average_large_unit,
						'log_average_medium_unit'     => $log_average_medium_unit,
						'log_average_small_unit'      => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				}else{					

					$data_log[] = array(
						'log_id'                         => $row->log_id,
						'log_large_unit_purchase_price'  => $avg_lg,
						'log_medium_unit_purchase_price' => $avg_md,
						'log_small_unit_purchase_price'  => $avg_sm,
						'log_total_transaction_value'    => $log_total_transaction_value,
						'log_total_stock'                => $total_stok,
						'log_total_stock_value'          => $total_stok_rupiah,
						'log_average_large_unit'         => $log_average_large_unit,
						'log_average_medium_unit'        => $log_average_medium_unit,
						'log_average_small_unit'         => $log_average_small_unit,
						// 'timestamp'                      => change_format_date($date). " " .date("h:i:s")
					);
				}
				

				
			}
			
			
		}

		$after_row_log_update = $this->Logs_model->update_item_batch($data_log);

		return true;
	}
	
	public function export_excel($id) {

		$where    = [];
		$where['b.header_id'] = $id;

		$get_data = $this->Transfer_model->transfer_advance2($where)->result();

		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("TRANSFER")
							   ->setSubject("TRANSFER")
							   ->setDescription("TRANSFER")
							   ->setKeywords("TRANSFER");


	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "nomor");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "Dari Gudang");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "Ke Gudang");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('F1', "Satuan Besar");
	    $excel->setActiveSheetIndex(0)->setCellValue('G1', "Qty Besar");
	    $excel->setActiveSheetIndex(0)->setCellValue('H1', "Satuan Sedang");
	    $excel->setActiveSheetIndex(0)->setCellValue('I1', "Qty Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('J1', "Satuan Kecil");
	    $excel->setActiveSheetIndex(0)->setCellValue('K1', "Qty Kecil");


	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 9
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			$gudang_from = $this->Warehouses_model->get_data(array('warehouse_id' => $get_row->gudang_from))->row();
			$gudang_to = $this->Warehouses_model->get_data(array('warehouse_id' =>$get_row->gudang_to ))->row();

			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, change_format_date($get_row->header_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $gudang_from->warehouse_name);
		    $excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $gudang_to->warehouse_name);
		    	$item_name = str_replace(["'", '"'], "", $get_row->item_name);
		    $excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, str_replace(["\r", "\n"], "", $item_name));
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow,($get_row->lg_qty  > 0 ?  $get_row->large_unit: ''));
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->lg_qty  > 0 ? $get_row->lg_qty : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->md_qty  > 0 ?  $get_row->medium_unit: ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, ($get_row->md_qty  > 0 ?  $get_row->md_qty: ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, ($get_row->sm_qty  > 0 ?  $get_row->small_unit: ''));
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, ($get_row->sm_qty  > 0 ?  $get_row->sm_qty: ''));


			// $username = $this->Users_model->get_data_advance($get_row->sales_order_header_user_id)->row()->fullname;
			// $excel->setActiveSheetIndex(0)->setCellValue('AA'.$numrow, $username);
			// $excel->setActiveSheetIndex(0)->setCellValue('AB'.$numrow, rtrim($get_row->sales_order_header_description));


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			// $excel->getActiveSheet()->getStyle('A'.$numrow.':O'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			// if($ppn_status == '3'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_warning);
			// }

			// $excel->getActiveSheet()->getStyle('G'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			// $excel->getActiveSheet()->getStyle('N'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("TRANSFER");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		// $date_now = change_format_date(date_now(), 'Ymd');
		$filename = $get_data[0]->header_number.'.csv';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    // $write = PHPExcel_IOFactory::createWriter($excel, 'Excel5');
		$write = new PHPExcel_Writer_CSV($excel);
	    $write->save('php://output');
	}

	public function delete()
	{
	    $id = $this->input->post('id');
        foreach ($id as $row) {
    		$delete_header = $this->Transfer_model->delete_header($row);
            if ($delete_header) {
    			$delete_type = $this->Transfer_model->delete_detail($row);
    		}
        }
        
        $response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

}

?>
