<?php

/**
 * Point Requirements Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Cash_in extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Cash_in_model');
		$this->load->model('Journals_model');
		$this->load->model('Accounts_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Kas Masuk';

		$this->twiggy_display('adm/cash_in/index', $data);
	}

	public function get_data_header()
	{
		$data = [];
        $fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		
		$startOfMonth = date('Y-m-01');
        $endOfMonth = date('Y-m-t');
		
		$where = [];
		$where['cash_in_header_date >='] = $startOfMonth;
        $where['cash_in_header_date <='] = $endOfMonth;
		if(isset($fromdate) && $fromdate != '')
		{
			$where['cash_in_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['cash_in_header_date <='] = change_format_date($todate);
		}
		$get_data = $this->Cash_in_model->cash_in_header($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->cash_in_header_id,
					'number'      => $get_row->cash_in_header_number,
					'account'     => $get_row->account_name,
					'from'        => $get_row->cash_in_header_from,
					'date'        => indonesian_date($get_row->cash_in_header_date),
					'description' => $get_row->cash_in_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title = "Tambah Kas Masuk";
		$header_data = array(null);
        
        $prefix           = "CI";
		$datenow          = date('Ym');
		$number_generator = $this->Cash_in_model->cash_in_autonumber();
		$autonumber       = $prefix . $datenow . $number_generator;
        
		$number  = $autonumber;
		$from  = '';
		$nominal  = 0;
		$description  = '';

		if ($id != 'new') {
			$title       = "Edit Kas Masuk";
			$where       = array('cash_in_header_id' => $id);
			$header_data = $this->Cash_in_model->cash_in_header($where)->row_array();
			$number      = $header_data['cash_in_header_number'];
			$from      = $header_data['cash_in_header_from'];
			$nominal  = $header_data['cash_in_header_nominal'];
			// $start_date  = $header_data['cash_in_header_period_start'];
			// $end_date    = $header_data['cash_in_header_period_end'];
			// $total_point = $header_data['cash_in_header_total'];
			$description  = $header_data['cash_in_header_description'];
		}

		$data['id']            = $id;
		$data['number']        = $number;
		$data['from']          = $from;
		$data['nominal']          = $nominal;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['description']   = $description;

		$data['account_data']   = $this->Accounts_model->get_data(array('kasbank' => 1))->result();

		$this->twiggy_display('adm/cash_in/edit', $data);
	}

	public function get_data_detail()
	{
		$id    = $this->input->post("id");
		$where = array('cash_in_detail_header_id' => $id);
		// $order = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Cash_in_model->cash_in_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->cash_in_detail_id,
					'detail_header_id' => $get_row->cash_in_detail_header_id,
				// 	'type_name'        => $get_row->account_type_name,
					'id'               => $get_row->cash_in_detail_account_id,
					'number'           => $get_row->account_header_number . $get_row->account_header_child_number . $get_row->account_number,
					'name'             => $get_row->account_name,
					'group'      => $get_row->account_group_name,
					'amount'           => number_format($get_row->cash_in_detail_amount),
					'description'      => $get_row->cash_in_detail_description
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Akun';
		$this->twiggy_display('adm/cash_in/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');
        $where = array('normal_balance' => "KREDIT");
		$get_data  = $this->Accounts_model->get_data_search($search,$where)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$data[] = array(
				'no'              => $no,
				'id'              => $get_row->account_id,
				'name'            => $get_row->account_name,
				'number'          => $get_row->account_header_number . $get_row->account_header_child_number . $get_row->account_number,
				// 'type_name'       => $get_row->account_type_name,
				'normal_balance'  => $get_row->normal_balance,
				'opening_balance' => number_format($get_row->opening_balance),
				'group'      => $get_row->account_group_name,
				'debit'           => 0,
				'credit'          => 0,
				'btncolor'        => '',
				'btnicon'         => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id          = $this->input->post('id');
		$number      = $this->input->post('number');
		$account     = $this->input->post('account');
		$terima_dari = $this->input->post('terima_dari');
		$nominal = $this->input->post('nominal');
		$total       = $this->input->post("total");
		$description = $this->input->post("description");

		$vuedata = $this->input->post('vuedata');

		$header_id   = $id;

	

		$header_data = [
			'cash_in_header_number'      => $number,
			'cash_in_header_date'        => date_now(),
			'cash_in_header_account_id'  => $account,
			'cash_in_header_from'        => $terima_dari,
			'cash_in_header_nominal'        => trims($nominal),
			'cash_in_header_total'       => trims($total),
			'cash_in_header_description' => $description,
		];
		

		$detail_data = [];
// 		$detail_data_jr = [];

		// if save $id = new else update data
		if ($id == "new") {
			// save header
			$save_header = $this->Cash_in_model->save_header($header_data);
			if ($save_header) {
				$header_id = $this->db->insert_id();
				$prefix           = "JR";
        		$datenow          = date('Ym');
        		$number_generator = $this->Journals_model->journal_autonumber();
        		$autonumberjurnal       = $prefix . $datenow . $number_generator;
        		$journal_data = [
        			'journal_header_trx_id'       => $header_id,
        			'journal_header_trx_type'     => "Kas/Bank",
        			'journal_header_number'       => ($autonumberjurnal),
        			'journal_header_date'         => date_now(),
        			'journal_header_total_debit'  => trims($total),
        			'journal_header_total_credit' => trims($total),
        			'journal_header_description'  => $number,
        		];
        		$save_header_jr = $this->Journals_model->save_header($journal_data);
        		
        		$header_id_jr = $this->db->insert_id();
        	
				foreach ($vuedata as $row) {
					$detail_data[] = [
						'cash_in_detail_header_id'      => $header_id,
						'cash_in_detail_account_id'     => $row['id'],
						'cash_in_detail_account_number' => $row['number'],
						'cash_in_detail_account_name'   => $row['name'],
						'cash_in_detail_amount'         => trims($row['amount']),
						'cash_in_detail_description'    => $row['description']
					];
					$detail_data_jr[] = [
        				'journal_detail_trx_id'         => $header_id,
        				'journal_detail_trx_type'       => "Kas/Bank",
        				'journal_detail_header_id'      => $header_id_jr,
        				'journal_detail_account_id'     =>  $row['id'],
        				'journal_detail_account_number' => $row['number'],
        				'journal_detail_account_name'   =>  $row['name'],
        				'journal_detail_account_group'      => $row['group'],
        				// 'journal_detail_debit'          => trims($row['amount']),
        				'journal_detail_credit'         => trims($row['amount']),
        				'journal_detail_description'    => ""
        			];
				}
	            $account_data = $this->Accounts_model->get_data(array('account_id' => $account))->row();
        		$detail_data_frt[] = [
        				'journal_detail_trx_id'         => $header_id,
        				'journal_detail_trx_type'       => "Kas/Bank",
        				'journal_detail_header_id'      => $header_id_jr,
        				'journal_detail_account_id'     =>  $account_data->account_id,
        				'journal_detail_account_number' => $account_data->account_number,
        				'journal_detail_account_name'   =>  $account_data->account_name,
        				'journal_detail_account_group'      => $account_data->account_group_name,
        				'journal_detail_debit'          => trims($nominal),
        				// 'journal_detail_credit'         => trims($row['amount']),
        				'journal_detail_description'    => ""
        			];
				$save_detail = $this->Cash_in_model->save_detail($detail_data, true);
				$save_detail_frt = $this->Journals_model->save_detail($detail_data_frt, true);
	            $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);
	             
				if ($save_detail) {
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {

			$delete_detail = $this->Cash_in_model->delete_detail($id);
			$jr_delheader = $this->Journals_model->delete_headerbytrxid($id, "Kas/Bank");
			$jr_deldetail = $this->Journals_model->delete_detailbytrxid($id, "Kas/Bank");

			if ($delete_detail) {
				$save_header = $this->Cash_in_model->update_header($id, $header_data);
				$prefix           = "JR";
        		$datenow          = date('Ym');
        		$number_generator = $this->Journals_model->journal_autonumber();
        		$autonumberjurnal       = $prefix . $datenow . $number_generator;
        		$journal_data = [
        			'journal_header_trx_id'       => $id,
        			'journal_header_trx_type'     => "Kas/Bank",
        			'journal_header_number'       => ($autonumberjurnal),
        			'journal_header_date'         => date_now(),
        			'journal_header_total_debit'  => trims($total),
        			'journal_header_total_credit' => trims($total),
        			'journal_header_description'  => $number,
        		];
        		$save_header_jr = $this->Journals_model->save_header($journal_data);
                $header_id_jr = $this->db->insert_id();
				if ($save_header) {
					// $header_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
						$detail_data[] = [
							'cash_in_detail_header_id'      => $header_id,
							'cash_in_detail_account_id'     => $row['id'],
							'cash_in_detail_account_number' => $row['number'],
							'cash_in_detail_account_name'   => $row['name'],
							'cash_in_detail_amount'         => trims($row['amount']),
							'cash_in_detail_description'    => $row['description']
						];
						$detail_data_jr[] = [
        				'journal_detail_trx_id'         => $id,
        				'journal_detail_trx_type'       => "Kas/Bank",
        				'journal_detail_header_id'      => $header_id_jr,
        				'journal_detail_account_id'     =>  $row['id'],
        				'journal_detail_account_number' => $row['number'],
        				'journal_detail_account_name'   =>  $row['name'],
        				'journal_detail_account_group'      => $row['group'],
        				// 'journal_detail_debit'          => trims($row['amount']),
        				'journal_detail_credit'         => trims($row['amount']),
        				'journal_detail_description'    => ""
        			];
					}
                    $account_data = $this->Accounts_model->get_data(array('account_id' => $account))->row();
            		$detail_data_frt[] = [
            				'journal_detail_trx_id'         => $header_id,
            				'journal_detail_trx_type'       => "Kas/Bank",
            				'journal_detail_header_id'      => $header_id_jr,
            				'journal_detail_account_id'     =>  $account_data->account_id,
            				'journal_detail_account_number' => $account_data->account_number,
            				'journal_detail_account_name'   =>  $account_data->account_name,
            				'journal_detail_account_group'      => $account_data->account_group_name,
            				'journal_detail_debit'          => trims($nominal),
            				// 'journal_detail_credit'         => trims($row['amount']),
            				'journal_detail_description'    => ""
            			];

				
					$save_detail = $this->Cash_in_model->save_detail($detail_data, true);
					$save_detail_frt = $this->Journals_model->save_detail($detail_data_frt, true);
                    $save_detail_jr = $this->Journals_model->save_detail($detail_data_jr, true);
					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');
		$data_log = [];
		foreach ($id as $row) {
			$delete_header = $this->Cash_in_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Cash_in_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header = array('cash_in_header_id' => $id);
		$where_detail = array('cash_in_detail_header_id' => $id);

		$header = $this->Cash_in_model->cash_in_header($where_header)->row_array();
		$detail = $this->Cash_in_model->cash_in_detail($where_detail)->result();

		$data['content_title'] = 'Print Ketentuan Poin';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/cash_in/print_out', $data);
	}
}
