<?php
/**
 * Programs Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Programs_model extends Model {
	  
	public function get_data_class($id='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('master_program_classes');

    	if ($id != '') {
			$sql->where('program_class_id', $id);
		}

		$sql->order_by('program_class_sort', 'asc');

		$get = $sql->get();

		return $get;
	}

	public function get_data_type($id='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('master_program_types');

    	if ($id != '') {
			$sql->where('program_type_id', $id);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_accreditation($id='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('master_program_accreditations');

    	if ($id != '') {
			$sql->where('program_accreditation_id', $id);
		}

		$get = $sql->get();

		return $get;
	}

	public function program_header($id='', $type_id='', $class_id='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('program_headers a');
	    $sql->join('master_program_classes b', 'b.program_class_id = a.program_header_class_id', 'inner');
	    $sql->join('master_program_types c', 'c.program_type_id = a.program_header_type_id', 'inner');
	    $sql->join('master_program_accreditations d', 'd.program_accreditation_id = a.program_header_accreditation_id', 'left');

    	if ($id != '') {
			$sql->where('program_header_id', $id);
		}

		if ($type_id != '') {
			$sql->where('program_header_type_id', $type_id);
		}

		if ($class_id != '') {
			$sql->where('program_header_class_id', $class_id);
		}

		$sql->order_by('program_header_name', 'ASC');

		$get = $sql->get();

		return $get;
	}

	public function program_detail($id="", $all=true)
	{
		$sql = $this->db;

		if($all){
			$sql->select('*');
		}else{
			$sql->select('requirement_id');
		}
		
	    $sql->from('program_details a');
	    $sql->join('master_requirements b', 'b.requirement_id = a.program_detail_requirement_id', 'inner');

		if ($id != "") {
			$sql->where("program_detail_header_id", $id);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('program_headers', $data);
		}

		return $this->db->insert('program_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('program_details', $data);
		}

		return $this->db->insert('program_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('program_header_id', $id);
		return $this->db->update('program_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("program_header_id", $id);
		return $this->db->delete("program_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("program_detail_header_id", $id);
		return $this->db->delete("program_details");
	}

}

?>
