<?php
/**
 * Visit Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Visit extends BaseController
{
    /**
     * Constructor CodeIgniter
     */
    public function __construct()
    {
        parent:: __construct();
        $this->auth->check_auth();

        // load model
        $this->load->model('Visit_model');
        $this->load->model('Sales_model');
        $this->load->model('Customers_model');

    }

    /**
     * Halaman Index
     *
     * @return HTML
     */

    public function index()
    {
        $data['content_title'] = 'Jadwal Kunjungan';

        $this->twiggy_display('adm/visit/index', $data);
    }

    public function get_data_header()
    {
        $data     = [];
        $order    = 'header_id DESC';
        $get_data = $this->Visit_model->visit_header('', $order)->result();

        // ketika data tersedia
        // maka generate data json untuk Datatable
        if ($get_data) {
            $no = 1;
            foreach ($get_data as $get_row) {
                $data[] = [
                    'no'     => $no,
                    'id'     => $get_row->header_id,
                    'number' => $get_row->header_number,
                    'date'   => indonesian_date($get_row->header_date),
                    'sales'  => $get_row->sales_name,
                    'desc'   => $get_row->header_description
                ];
                $no++;
            }
        }

        $response = [
            'data'         => $data,
            'recordsTotal' => count($data),
        ];

        output_json($response);
    }

    public function get_autonumber()
    {
        $id               = $this->input->post('id');
        $datenow          = date('mY');
        $number_generator = '';
        $where            = ['sales_id' => $id];
        $sales_data       = $this->Sales_model->get_data($where)->row();

        if ($sales_data) {
            $number_generator = $this->Visit_model->visit_autonumber(
                $sales_data->sales_code
            );
        }

        $prefix     = $sales_data->sales_code;
        $autonumber = $prefix . $datenow . $number_generator;

        echo json_encode($autonumber);
    }

    public function edit($id = 'new')
    {
        $title       = 'Tambah Jadwal Kunjungan';
        $header_data = [null];

        $autonumber = '';

        $date_text = date_now();

        if ($id != 'new') {
            $title       = 'Edit Jadwal Kunjungan';
            $where       = ['header_id' => $id];
            $header_data = $this->Visit_model->visit_header($where)->row_array();
            $autonumber  = $header_data['header_number'];
            $date_text   = $header_data['header_date'];
        }

        $data['id']            = $id;
        $data['content_title'] = $title;
        $data['header_data']   = $header_data;
        $data['sales_data']    = $this->Sales_model->get_data()->result();

        $data['autonumber'] = $autonumber;
        $data['date_text']  = $date_text;

        $this->twiggy_display('adm/visit/edit', $data);
    }

    public function get_data_detail()
    {
        $id    = $this->input->post('id');
        $where = ['header_id' => $id];

        $data     = [];
        $get_data = $this->Visit_model->visit_detail($where)->result();

        // ketika data tersedia
        // maka generate data json untuk Datatable
        if ($get_data) {
            $no = 1;
            foreach ($get_data as $get_row) {
                $data[] = [
                    'no'        => $no,
                    'detail_id' => $get_row->detail_id,
                    'header_id' => $get_row->header_id,
                    'date'      => $get_row->detail_date,
                    'id'       => $get_row->customer_id,
                    'name'     => $get_row->customer_name,
                    'address'  => $get_row->customer_address,
                    'group'    => $get_row->group_customer_name,
                    'checkin'  => '0000-00-00 00:00:00',
                    'checkout' => '0000-00-00 00:00:00'
                ];
                $no++;
            }
        }

        output_json($data);
    }

    public function get_embed()
    {
              $data            = [];
        $data['content_title'] = 'Data Pelanggan';
        $this->twiggy_display('adm/visit/embed', $data);
    }

    public function get_data_embed()
    {
        $data     = [];
        $response = [];
        $search   = $this->input->post('search');

        $get_data = $this->Customers_model->get_data_search($search)->result();

        $no = 0;
        foreach ($get_data as $get_row) {
            $data[] = [
                'no'       => $no,
                'id'       => $get_row->customer_id,
                'name'     => $get_row->customer_name,
                'address'  => $get_row->customer_address,
                'group'    => $get_row->group_customer_name,
                'checkin'  => '0000-00-00 00:00:00',
                'checkout' => '0000-00-00 00:00:00'
            ];

            $no++;
        }

        $response = [
            'data'         => $data,
            'recordsTotal' => count($data),
        ];

        output_json($response);
    }

    public function save()
    {
        $id          = $this->input->post('id');
        $number      = $this->input->post('number');
        $date        = $this->input->post('date');
        $sales       = $this->input->post('sales');
        $description = $this->input->post('description');

        $vuedata   = $this->input->post('vuedata');
        $header_id = $id;

        $header_data = [
            'header_number'      => $number,
            'header_date'        => change_format_date($date),
            'sales_id'           => $sales,
            'header_description' => $description
        ];

        $detail_data = [];

        // if save $id = new else update data
        if ($id == 'new') {
            // save header
            $save_header = $this->Visit_model->save_header($header_data);
            if ($save_header) {

                $header_id = $this->db->insert_id();
                foreach ($vuedata as $row) {
                    $detail_data[] = [
                        'header_id'   => $header_id,
                        'detail_date' => change_format_date($row['date']),
                        'customer_id' => $row['id']
                    ];
                }

                $save_detail = $this->Visit_model->save_detail($detail_data, true);

                if ($save_detail) {
                    $msg    = 'Berhasil menyimpan data';
                    $status = 'success';
                } else {
                    $msg    = 'Gagal menyimpan data';
                    $status = 'error';
                }
            } else {
                $msg    = 'Gagal menyimpan data';
                $status = 'error';
            }
        } else {
            $delete_detail = $this->Visit_model->delete_detail($id);

            if ($delete_detail) {
                $save_header = $this->Visit_model->update_header($id, $header_data);

                if ($save_header) {
                    // $header_id = $this->db->insert_id();
                    foreach ($vuedata as $row) {
                        $detail_data[] = [
                            'header_id'   => $header_id,
                            'detail_date' => change_format_date($row['date']),
                            'customer_id' => $row['id'],
                        ];
                    }

                    $save_detail = $this->Visit_model->save_detail($detail_data, true);

                    if ($save_detail) {
                        $msg    = 'Berhasil menyimpan data';
                        $status = 'success';
                    } else {
                        $msg    = 'Gagal menyimpan data';
                        $status = 'error';
                    }
                } else {
                    $msg    = 'Gagal menyimpan data';
                    $status = 'error';
                }
            } else {
                $msg    = 'Gagal menyimpan data';
                $status = 'error';
            }
        }

        $response = [
            'message' => $msg,
            'status'  => $status,
            'id'      => $header_id,
        ];
        output_json($response);
    }

    public function delete()
    {
        $id = $this->input->post('id');

        foreach ($id as $row) {

            $delete_header = $this->Visit_model->delete_header($row);

            if ($delete_header) {
                $delete_type = $this->Visit_model->delete_detail($row);
            }
        }

        $response = [
            'message' => 'Berhasil menghapus data',
            'status'  => 'success',
        ];

        output_json($response);
    }

    public function print_out($id)
    {
        $where_header = ['visit_header_id' => $id];
        $where_detail = ['visit_detail_header_id' => $id];

        $header = $this->Visit_model->visit_header($where_header)->row_array();
        $detail = $this->Visit_model->visit_detail($where_detail)->result();

        $data['content_title'] = 'Print Invoice Pembelian';
        $data['header']        = $header;
        $data['detail']        = $detail;

        $this->twiggy_display('adm/visit/print_out', $data);
    }
}

?>
