<?php
/**
 * Report Points Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_points extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Log_points_model');
		$this->load->model('Customers_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Poin';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
		
		$this->twiggy_display('adm/report_points/index', $data);
	}

	public function get_data_detail()
	{	
		$customer = $this->input->post("customer");
		$date_log = $this->input->post("date_log");

        $data  = [];
		$where = [];
		$order = ("b.customer_name, a.log_point_id ASC");

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['a.log_point_customer_id'] = $customer;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where['date(a.timestamp) <='] = change_format_date($date_log);
		}
		
		$where['log_point_earned !='] = 0;
		$get_data = $this->Log_points_model->get_data_advance($where, $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$transaction_status = ($get_row->log_point_type == 'SO' ? 'Dapat' : 'Tukar');
				$transaction_number = ($get_row->log_point_type == 'SO' ? $get_row->sales_order_header_number : $get_row->ptsredeem_number);

				$data[] = array(
					'no'                 => $no,
					'log_id'             => $get_row->log_point_id,
					'log_date'           => change_format_date($get_row->tms_log, 'd/m/Y'),
					'transaction_status' => $transaction_status,
					'transaction_number' => $transaction_number,
					'customer_name'              => $get_row->customer_name,
					'point'              => $get_row->log_point_earned,
					'point_total'        => $get_row->log_point_total
				);
                $no++;
                
			}
		}
		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('date_log', $date_log);

		output_json($data);
	}

	public function get_data_detail_total()
	{	
		$date_log = $this->input->post("date_log");

        $data  = [];
		$where = [];
		$ttl = 0;
		$get_data = $this->Log_points_model->get_data_point_total()->result();
		if(isset($date_log) && $date_log != '')
		{
			$get_data = $this->Log_points_model->get_data_point_total(change_format_date($date_log))->result();
		}

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			
			foreach($get_data as $get_row)
			{	
				$transaction_status = ($get_row->log_point_type == 'SO' ? 'Dapat' : 'Tukar');
				$transaction_number = ($get_row->log_point_type == 'SO' ? $get_row->sales_order_header_number : $get_row->ptsredeem_number);

				$data[] = array(
					'no'                 => $no,
					'log_id'             => $get_row->log_point_id,
					'customer_name'              => $get_row->customer_name,
					'log_date'           => change_format_date($get_row->timestamp, 'd/m/Y'),
					'transaction_status' => $transaction_status,
					'transaction_number' => $transaction_number,
					'point'              => $get_row->log_point_earned,
					'point_total'        => $get_row->log_point_total
				);
                $no++;
				$ttl += $get_row->log_point_total;
			}
		}

		$this->session->set_userdata('date_log', $date_log);

		$response = [
			'data' => $data,
			'ttl' => $ttl
		];

		output_json($response);
	}

	public function export_excel() {

		$customer     = $this->session->userdata('customer');
		$date_log = $this->session->userdata('date_log');

		$where = [];
		$order = ("b.customer_name, a.log_point_id ASC");
		$customer_name  = '-';

		$date_text = ($date_log == '' ? '-' : change_format_date($date_log, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['a.log_point_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($date_log) && $date_log != '')
		{
			$where['date(a.timestamp) <='] = change_format_date($date_log);
		}
		$where['log_point_earned !='] = 0;
		$get_data = $this->Log_points_model->get_data_advance($where, $order)->result();

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("POIN")
							   ->setSubject("POIN")
							   ->setDescription("POIN")
							   ->setKeywords("POIN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Poin");
	    $excel->getActiveSheet()->mergeCells('A1:U1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3

		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$date_text);
		
	    $excel->setActiveSheetIndex(0)->setCellValue('A6', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('B6', "Status");
	    $excel->setActiveSheetIndex(0)->setCellValue('C6', "No. Transaksi");
		$excel->setActiveSheetIndex(0)->setCellValue('D6', "Jumlah Poin");
		$excel->setActiveSheetIndex(0)->setCellValue('E6', "Total Poin");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('D6')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('E6')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 7; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$transaction_status = ($get_row->log_point_type == 'SO' ? 'Dapat' : 'Tukar');
			$transaction_number = ($get_row->log_point_type == 'SO' ? $get_row->sales_order_header_number : $get_row->ptsredeem_number);
				
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, change_format_date($get_row->tms_log, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $transaction_status);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $transaction_number);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, $get_row->log_point_earned);
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->log_point_total);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':E'.$numrow)->applyFromArray($style_row);

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("POIN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'POIN_'.$customer_name.'_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

	public function export_excel_total() {

		$date_log = $this->session->userdata('date_log');

		$ttl = 0;
		$date_text = ($date_log == '' ? '-' : change_format_date($date_log, 'd/m/Y'));

        
		$get_data = $this->Log_points_model->get_data_point_total()->result();
		if(isset($date_log) && $date_log != '')
		{
			$get_data = $this->Log_points_model->get_data_point_total(change_format_date($date_log))->result();
		}

		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("POIN")
							   ->setSubject("POIN")
							   ->setDescription("POIN")
							   ->setKeywords("POIN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Poin");
	    $excel->getActiveSheet()->mergeCells('A1:U1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3

		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$date_text);
		
	    $excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('B5', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('C5', "Total Poin");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('B5')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('C5')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 6; // Set baris pertama untuk isi tabel adalah baris ke 4
	    $footer = 7; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$transaction_status = ($get_row->log_point_type == 'SO' ? 'Dapat' : 'Tukar');
			$transaction_number = ($get_row->log_point_type == 'SO' ? $get_row->sales_order_header_number : $get_row->ptsredeem_number);
				
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, change_format_date($get_row->timestamp, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->log_point_total);

	      	// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			$excel->getActiveSheet()->getStyle('A'.$numrow.':C'.$numrow)->applyFromArray($style_row);

			$ttl += $get_row->log_point_total;
	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
	      	$footer++; // Tambah 1 setiap kali looping
		}
		$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, "Total");
		$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $ttl);
		$excel->getActiveSheet()->mergeCells('A'.$numrow.':B'.$numrow);
		$excel->getActiveSheet()->getStyle('A'.$numrow.':C'.$numrow)->applyFromArray($style_row);

		// $excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow+1, "Total");
		// $excel->getActiveSheet()->mergeCells('A1:B');
		// $excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$date_text);
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("POIN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'POINTOTAL_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
