<?php
/**
 * Transfer Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Transfer_model extends Model {

	public function transfer_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(transfer_headers.header_number, 4) as serial_number', FALSE);
		$sql->where('MONTH(header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('transfer_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 0001;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function transfer_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('transfer_headers');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function transfer_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('transfer_details a');
	    $sql->join('master_items b', 'b.item_id = a.item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function transfer_advance($where='', $group='', $join_item=false)
	{
		$sql = $this->db;

		$sql->select('*, COALESCE(SUM(lg_qty),0) as large_qty, COALESCE(SUM(md_qty),0) as medium_qty, COALESCE(SUM(sm_qty), 0) as small_qty');
	    $sql->from('transfer_details a');
	    $sql->join('transfer_headers b', 'b.header_id = a.header_id', 'inner');
		if($join_item){
	    	$sql->join('master_items c', 'c.item_id = a.item_id', 'inner');
		}

		if ($where != '') {
			$sql->where($where);
		}

		if ($group != '') {
			$sql->group_by($group);
		}

		$get = $sql->get();

		return $get;
	}

	public function truncate_transfer_headers()
	{
		return $this->db->empty_table("transfer_headers");
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('transfer_headers', $data);
		}

		return $this->db->insert('transfer_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('transfer_details', $data);
		}

		return $this->db->insert('transfer_details', $data);
	}

	public function update_header($where, $data) {
		$this->db->where($where);
		return $this->db->update('sales_order_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("transfer_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("transfer_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("transfer_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("transfer_details");
	}

}

?>
