<?php
/**
 * Access Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Access_model extends Model {


	public function access_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('access_headers');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function access_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select("*");
		$sql->from("access_details a");
		$sql->join('access_menus b', 'b.menu_id = a.menu_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_menu($search='')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('access_menus');

    	if ($search != '')
		{
			$sql->like('menu_sub', $search);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('access_headers', $data);
		}

		return $this->db->insert('access_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('access_details', $data);
		}

		return $this->db->insert('access_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('header_id', $id);
		return $this->db->update('access_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("access_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("header_id", $id);
		return $this->db->delete("access_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("access_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("access_details");
	}

}

?>
