<?php
/**
 * Debts Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Debts extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Debts_model');
		$this->load->model('Purchase_orders_model');
		$this->load->model('Purchase_returns_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Banks_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
		$data['content_title'] = 'Pembayaran Hutang';
		
		$this->twiggy_display('adm/debts/index', $data);
	}
	 
	public function get_data_header()
	{	
		$data = [];
		$order = "debt_header_id DESC";
		$get_data = $this->Debts_model->debt_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->debt_header_id,
					'number'       => $get_row->debt_header_number,
					'date'         => indonesian_date($get_row->debt_header_date),
					'supplier'     => $get_row->supplier_name,
					'sub_total'    => number_format($get_row->debt_header_sub_total),
					'return_total' => number_format($get_row->debt_header_return_total),
					'grand_total'  => number_format($get_row->debt_header_grand_total),
					'description'  => $get_row->debt_header_description,
				);
				$no++;
			}
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

        output_json($response);
	}

	public function get_autonumber()
	{
		$id      = $this->input->post('id');
		$datenow = date('mY');
		$number_generator = '';
		$where   = array('supplier_id' => $id);
		$supplier_data  = $this->Suppliers_model->get_data($where)->row();

		if($supplier_data){
			$number_generator = $this->Debts_model->debt_autonumber($supplier_data->supplier_code);
		}
		
		$prefix     = "DB-".$supplier_data->supplier_code;
		$autonumber = $prefix.$datenow.$number_generator;

		echo json_encode($autonumber);
	}

 	public function edit($id = 'new')
	{
		$title = "Tambah Pembayaran Hutang";
		$header_data = array(null);

		$autonumber = '';

		$date_text   = date_now();

	    if($id != 'new')
	    {
			$title       = "Edit Pembayaran Hutang";
			$where       = array('debt_header_id' => $id);
			$header_data = $this->Debts_model->debt_header($where)->row_array();
			$autonumber  = $header_data['debt_header_number'];
			$date_text   = $header_data['debt_header_date'];
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['supplier_data'] = $this->Suppliers_model->get_data()->result();
		$data['bank_data']     = $this->Banks_model->get_data()->result();

		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;

		$this->twiggy_display('adm/debts/edit', $data);
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");
		$where       = array('debt_detail_header_id' => $id);
		$order       = array('purchase_order_header_number' => 'asc');

		$data = [];
		$get_data = $this->Debts_model->debt_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->debt_detail_id,
					'detail_header_id' => $get_row->debt_detail_header_id,
					'id'               => $get_row->debt_detail_purchase_order_header_id,
					'number'           => $get_row->purchase_order_header_number,
					'date'             => indonesian_date($get_row->purchase_order_header_date),
					'sub_total'        => number_format($get_row->debt_detail_price),
					'discount'         => number_format($get_row->debt_detail_discount_percentage),
					'discount_total'   => number_format($get_row->debt_detail_discount_total),
					'return_total'     => number_format($get_row->debt_detail_return_total),
					'total'            => number_format($get_row->debt_detail_total),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Pembelian';
		$this->twiggy_display('adm/debts/embed', $data);
	}

	public function get_data_embed()
	{
		$data     = [];
		$response = [];
		$id       = $this->input->post('id');
		$supplier = $this->input->post('supplier');
		$search   = $this->input->post('search');

		$type = ($id == 'new' ? 'new' : 'edit');
		$get_data  = $this->Purchase_orders_model->purchaseorder_headersearch($type, $supplier, $search)->result();

		$no = 0;
		foreach($get_data as $get_row)
		{	
			$where        = array('purchase_order_header_id' => $get_row->purchase_order_header_id);
			$return_total = 0;
			$return_data  = $this->Purchase_returns_model->purchasereturn_header($where)->row();
			if($return_data){
				$return_total = $return_data->purchase_return_header_grand_total;
			}
			$total = ($get_row->purchase_order_header_grand_total - $return_total);
			$data[] = array(
				'no'           => $no,
				'id'           => $get_row->purchase_order_header_id,
				'number'       => $get_row->purchase_order_header_number,
				'date'         => indonesian_date($get_row->purchase_order_header_date, 'd/m/Y'),
				'sub_total'    => number_format($get_row->purchase_order_header_grand_total),
				'return_total' => number_format($return_total),
				'total'        => number_format($total),
			);

			$no++;
		}

		$response = [
            'data'         => $data,
            'recordsTotal' => count($data)
        ];

		output_json($response);
	}

	public function save()
	{	
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$supplier       = $this->input->post("supplier");
		$payment_method = $this->input->post("payment_method");
		$bank           = $this->input->post("bank");
		$number_giro    = $this->input->post("number_giro");
		$payment_due    = $this->input->post("payment_due");
		$sub_total      = $this->input->post("sub_total");
		$return_total   = $this->input->post("return_total");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");
		
		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;

		$payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));
		
		$header_data = [
			'debt_header_number'         => $number,
			'debt_header_date'           => change_format_date($date),
			'debt_header_supplier_id'    => $supplier,
			'debt_header_bank_id'        => $bank,
			'debt_header_payment_method' => $payment_method,
			'debt_header_number_giro'    => $number_giro,
			'debt_header_payment_due'    => $payment_due_data,
			'debt_header_sub_total'      => trims($sub_total),
			'debt_header_return_total'   => trims($return_total),
			'debt_header_grand_total'    => trims($grand_total),
			'debt_header_description'    => $description
		];

		$detail_data = [];

		// if save $id = new else update data
		if($id == "new")
		{
			// save header
			$save_header = $this->Debts_model->save_header($header_data);
			if($save_header)
			{
				$header_id = $this->db->insert_id();
				foreach($vuedata as $row)
				{
					$detail_data[] = [
						'debt_detail_header_id'                => $header_id,
						'debt_detail_purchase_order_header_id' => $row['id'],
						'debt_detail_price'                    => trims($row['sub_total']),
						'debt_detail_discount_percentage'      => trims($row['discount']),
						'debt_detail_discount_total'           => trims($row['discount_total']),
						'debt_detail_return_total'             => trims($row['return_total']),
						'debt_detail_total'                    => trims($row['total']),
					];

					$data = array(
						'status_paid'  => 1
					);

					$where = $row['id'];

					$update_status_paid = $this->Purchase_orders_model->update_header($where, $data);
				}
				
				$save_detail = $this->Debts_model->save_detail($detail_data, true);
				
				if($save_detail)
				{
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				}
				else
				{
					$msg    = "Gagal menyimpan data";
					$status = "error";	
				}
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
			
		}else{
			
			$where_detail    = array('debt_detail_header_id' => $header_id);
			$get_data_detail = $this->Debts_model->debt_detail($where_detail)->result();
			foreach($get_data_detail as $row_detail){
				$data = array(
					'status_paid'  => 0
				);

				$where = $row_detail->debt_detail_purchase_order_header_id;

				$update_status_paid = $this->Purchase_orders_model->update_header($where, $data);
			}

			$delete_detail = $this->Debts_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Debts_model->update_header($id, $header_data);

				if($save_header)
				{
					// $header_id = $this->db->insert_id();
					foreach($vuedata as $row)
					{
						$detail_data[] = [
							'debt_detail_header_id'                => $header_id,
							'debt_detail_purchase_order_header_id' => $row['id'],
							'debt_detail_price'                    => trims($row['sub_total']),
							'debt_detail_discount_percentage'      => trims($row['discount']),
							'debt_detail_discount_total'           => trims($row['discount_total']),
							'debt_detail_return_total'             => trims($row['return_total']),
							'debt_detail_total'                    => trims($row['total']),
						];

						$data = array(
							'status_paid'  => 1
						);

						$where = $row['id'];

						$update_status_paid = $this->Purchase_orders_model->update_header($where, $data);
					}

					$save_detail = $this->Debts_model->save_detail($detail_data, true);
					
					if($save_detail)
					{
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					}
					else
					{
						$msg    = "Gagal menyimpan data";
						$status = "error";	
					}
				}else{
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}

			}else{
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');
		
		foreach($id as $row)
		{	
			$where_detail    = array('debt_detail_header_id' => $row);
			$get_data_detail = $this->Debts_model->debt_detail($where_detail)->result();
			foreach($get_data_detail as $row_detail){
				$data = array(
					'status_paid'  => 0
				);

				$where = $row_detail->debt_detail_purchase_order_header_id;

				$update_status_paid = $this->Purchase_orders_model->update_header($where, $data);
			}

			$delete_header = $this->Debts_model->delete_header($row);
			
			if($delete_header){
				$delete_type = $this->Debts_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{	
		$where_header = array('debt_header_id' => $id);
		$where_detail = array('debt_detail_header_id' => $id);

		$header = $this->Debts_model->debt_header($where_header)->row_array();
		$detail = $this->Debts_model->debt_detail($where_detail)->result();

		$data['content_title'] = 'Print Invoice Pembelian';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/debts/print_out', $data);
	}

}

?>
