<?php
/**
 * Sales Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Purchase_returns_model extends Model {

	public function purchasereturn_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*, a.timestamp as tmstamp_so');
		$sql->from('purchase_return_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_return_header_supplier_id', 'left');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('purchase_return_details a');
	    $sql->join('purchase_return_headers b', 'b.purchase_return_header_id = a.purchase_return_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.purchase_return_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_detail_advance($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('purchase_return_details a');
	    $sql->join('purchase_return_headers b', 'b.purchase_return_header_id = a.purchase_return_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.purchase_return_detail_item_id', 'left');
	    $sql->join('master_suppliers d', 'd.supplier_id = b.purchase_return_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_advance($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*, SUM(a.purchase_return_detail_total) as total_return');
	    $sql->from('purchase_return_details a');
	    $sql->join('purchase_return_headers b', 'b.purchase_return_header_id = a.purchase_return_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.purchase_return_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('purchase_return_headers', $data);
		}

		return $this->db->insert('purchase_return_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('purchase_return_details', $data);
		}

		return $this->db->insert('purchase_return_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('purchase_return_header_id', $id);
		return $this->db->update('purchase_return_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("purchase_return_header_id", $id);
		return $this->db->delete("purchase_return_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("purchase_return_detail_header_id", $id);
		return $this->db->delete("purchase_return_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("purchase_return_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("purchase_return_details");
	}

}

?>
