<?php
/**
 * Branches Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Branches extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Branches_model');
	}
	
	public function index() {
		$data['content_title'] = 'Cabang';

		if(check_roles('1') or check_roles('2') or check_roles('3')){
			$this->twiggy_display('adm/branches/index', $data);
		}else{
			redirect("Error");
		}
	}

	public function get_data() {
		$data = [];
		$get_data = $this->Branches_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$data[] = array(
					'no'         => $no,
					'id'         => $get_row->branch_id,
					'name'       => $get_row->branch_name,
					'telephone'  => $get_row->branch_telephone,
					'address'    => $get_row->branch_address
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('branch_id' => $id);
			$get_data = $this->Branches_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/branches/edit', $data);
	}

	public function save() {
		// post
		$id        = $this->input->post('id');
		$name      = $this->input->post('name');
		$telephone = $this->input->post('telephone');
		$address   = $this->input->post('address');
		$action    = $this->input->post('action');

		$data_save = array(
			'branch_name'   => $name,
			'branch_telephone' => $telephone,
			'branch_address'   => $address,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Branches_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Branches_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Branches_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$name  = $this->input->post('id');
		$where = array('branch_name' => $name);

		$check = $this->Branches_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
