<?php
/**
 * Suppliers Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Suppliers extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Suppliers_model');
		$this->load->model('Purchase_orders_model');
	}
	
	public function index() {
		$data['content_title'] = 'Supplier';

		$this->twiggy_display('adm/suppliers/index', $data);
	}

	public function get_data() {
		$data = [];
		$get_data = $this->Suppliers_model->get_data()->result();

		if($get_data) {
			$no=1;
			foreach($get_data as $get_row) {

				$po_data = false;
				$whe_purchorder = array('purchase_order_header_supplier_id' => $get_row->supplier_id);
				$get_purchorder = $this->Purchase_orders_model->purchaseorder_header($whe_purchorder)->result();

				if($get_purchorder){
					$po_data = true;
				}

				$payment_term = ($get_row->supplier_payment_term == "0" ? "-" : $get_row->supplier_payment_term. " Hari");
				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->supplier_id,
					'code'         => $get_row->supplier_code,
					'name'         => $get_row->supplier_name,
					'telephone'    => $get_row->supplier_telephone,
					'address'      => $get_row->supplier_address,
					'payment_term' => $payment_term,
					'po_data'      => $po_data
				);
			$no++;
			}
		}

		$response = [ 
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id='new') {
		$title    = "Tambah";
		$get_data = array();

		if($id != 'new') {
			$title    = "Edit";
			$where = array('supplier_id' => $id);
			$get_data = $this->Suppliers_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/suppliers/edit', $data);
	}

	public function save() {
		// post
		$id        = $this->input->post('id');
		$code      = $this->input->post('code');
		$name      = $this->input->post('name');
		$telephone = $this->input->post('telephone');
		$address   = $this->input->post('address');
		$payment_term   = $this->input->post('payment_term');
		$action    = $this->input->post('action');

		$data_save = array(
			'supplier_code'   => $code,
			'supplier_name'   => $name,
			'supplier_telephone	'=> $telephone,
			'supplier_address'   => $address,
			'supplier_payment_term'   => $payment_term,
		);

		if($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Suppliers_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Suppliers_model->update($id, $data_save);
		}

		if($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		}

		else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete() {
		$id = $this->input->post('id');

		foreach($id as $row) {
			$delete_type = $this->Suppliers_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id() {
		$code  = $this->input->post('id');
		$where = array('supplier_code' => $code);

		$check = $this->Suppliers_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}

}

?>
