/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlPrintOut: window.APP.siteUrl + 'adm/transfer/export_excel/',
        urlIndex: window.APP.siteUrl + 'adm/transfer/',
        urlList: window.APP.siteUrl + 'adm/transfer/get_embed',
        urlRequestData: window.APP.siteUrl + 'adm/transfer/get_data_detail',
        urlRequestData2: window.APP.siteUrl + 'adm/transfer/get_data_detail2',
		urlDeleteData: window.APP.siteUrl + 'adm/transfer/delete_item',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					paymentMethod: '',
					ppn_status_color: '',
					paid: false,
					totalRemaining: 0,
					totalChange: 0,
					overprice: '',
				},
				methods: {
					detailAdd: function () {
						// show modal
						var customer = $("#wrfrom-select").val();

						if(customer == ""){
							toastr.warning('Silahkan pilih gudang terlebih dahulu!')
						}else{
							$(that.elModal).modal("show");
							$.ajax({
								url: that.urlList,
								success: function (response) {
									$(that.elModalC).html(response);
								}
							});
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								// var ii = $('.check-sub');
								ii.prop('checked', false);

							}, 100);
						}

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete2: function (row, idx) {
						var vue = this;
							

							Swal.fire({
								title: 'Anda yakin?',
								text: "Ingin menghapus data ini?",
								type: 'warning',
								showCancelButton: true,
								confirmButtonColor: '#3085d6',
								cancelButtonColor: '#d33',
								confirmButtonText: 'Ya, Hapus!',
								cancelButtonText: 'Batal'
							}).then((result) => {
								if (result.value) {
									$.ajax({
										type: "POST",
										dataType: 'json',
										url: that.urlDeleteData,
										data: {
											id: $("#id").val(),
											item: vue.detailData[idx],
										},
										success: function (response) {
											window.FORM.showNotification(response.message, response.status);
											// parentThis.elDatatable.ajax.reload();
											// console.log("deleted");
											vue.detailData.splice(idx, 1);
										}
									});
								}
							})	

							vue.countSubTotal();
					},

					cekIfZero: function()
					{
						var vue = this;

						// console.log();
						console.log(that.objectFindByKey(vue.detailData, 'total', '0').length);
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();
						var warehouse = $("#wrfrom-select").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id,
								'warehouse':warehouse
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								console.log(vue.detailData);
								$(that.elVue).unblock();
                    		}
                    	});
					},

					handleData2: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData2,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
					},
					
					handleDsc: function (row) {
						var vue = this;

						// console.log(row);
					},

					countOverprice: function () {
						var vue = this;

						var grandTotal = 0;
						var totalAmmountLg = 0;
						var totalAmmountMd = 0;
						var totalAmmountSm = 0;
						var items = vue.detailData;

						// console.log(vue.detailData);
						for (var i in items) {
							totalAmmountLg += (Number(items[i].overprice_lg));
							totalAmmountMd += (Number(items[i].overprice_md));
							totalAmmountSm += (Number(items[i].overprice_sm));
						}
						
						grandTotal = (totalAmmountLg + totalAmmountMd + totalAmmountSm);

						if(Number(grandTotal) > 0){
							vue.$set(vue, 'overprice', 'bg-danger');
						}else{
							vue.$set(vue, 'overprice', '');
						}

						return Number(grandTotal);
					},

					handlePPNStatus: function(row, fieldname, value) {
						var vue = this;
						var total = 0;
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));

						var ppn_total = 0
						if(row.ppn_status == '2'){
							ppn_total = (total * 0.10);
							vue.$set(row, 'ppn_status_color', 'bg-success');
						}else if(row.ppn_status == '1'){
							ppn_total = 0;
							vue.$set(row, 'ppn_status_color', '');
						}else{
							ppn_total = 0;
							vue.$set(row, 'ppn_status_color', 'bg-warning');
						}
						vue.$set(row, 'ppn_total', ppn_total);
						vue.$set(row, 'total', (total + ppn_total).toLocaleString("en-US"));
					},
					
					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;

						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty') {
				// 			vue.handleStock(row, field_name, value);
						}
						if (field_name == 'md_unit_qty') {
				// 			vue.handleStock(row, field_name, value);
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc' || field_name == 'sm_unit_dsc') {
				// 			vue.handleStock(row, field_name, value);
						}

						var ttl_stock = 0;
						var ttls_lg = 0;
						var ttls_md = 0;
						var ttls_sm = 0;
						
						ttl_stock = row.total_stock;
						ttls_lg   = (row.lg_unit_cnt == 0 ? '0' : Math.floor(row.total_stock / row.lg_unit_cnt));
						ttl_stok  = (ttl_stock - (ttls_lg * row.lg_unit_cnt));
						ttls_md   = (row.md_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / row.md_unit_cnt));
						ttl_stok  = (ttl_stok - (ttls_md * row.md_unit_cnt));
						ttls_sm   = (row.sm_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / row.sm_unit_cnt));
						vue.$set(row, 'ttls_lg', ttls_lg);
						vue.$set(row, 'ttls_md', ttls_md);
						vue.$set(row, 'ttls_sm', ttls_sm);
					},

					handleStock: function(row, field_name, value) {
						var vue = this;

						lg_calc = 0;
						md_calc = 0;
						sm_calc = 0;
                        var warehouse = $('#wrfrom-select').val();
                        if(warehouse == 5){
                            calc = row.ttls_lg_gd1;
                        }else if(warehouse == 6){
                            calc = row.ttls_lg_gd2;
                        }else if(warehouse == 7){
                            calc = row.ttls_lg_gd3;
                        }
				// 		calc = row.total_stock_stored;
						calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

						if(calc < 0){
							toastr.warning('Stok tidak mencukupi!');
							if(field_name == 'lg_unit_qty'){
								vue.$set(row, 'lg_unit_qty', 0);
								if(warehouse == 5){
								    calc = (row.ttls_lg_gd1 - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
                                }else if(warehouse == 6){
                                   calc = (row.ttls_lg_gd2 - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
                                }else if(warehouse == 7){
                                    calc = (row.ttls_lg_gd3 - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
                                }
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'md_unit_qty'){
								vue.$set(row, 'md_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'sm_unit_qty'){
								vue.$set(row, 'sm_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
						}
						
						var left_stock_large = 0;
						left_stock_large = (calc/row.lg_unit_cnt);

						if(left_stock_large <= row.minimum_stock){
							toastr.error('Barang telah mencapai stok minimum!')
							vue.$set(row, 'bg_min_stock', 'bg-danger');
						}else{
							vue.$set(row, 'bg_min_stock', '');
						}
						
						vue.$set(row, 'total_stock', calc);
					},

					countSubTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += 0;
						}
						vue.handlePaid();
						return totalAmmount.toLocaleString("en-US");
					},

					countPPNTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].ppn_total);
						}

						return totalAmmount.toLocaleString("en-US");
					},

					handlePaid: function (Event) {
						var vue = this;
						var payment_method = $("#payment-method-select").val();
						var paid_total = $("#paid_total").val();
						var totalAmmount = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);

						if(Event != ''){
							if(payment_method == 'Kredit'){
								if(totalAmmount > paid_total.replace(/,/g, '')){
									vue.$set(vue, 'paid', true);
								}else{
									vue.$set(vue, 'paid', false);
								}
							}

							if(payment_method == 'Tunai'){
								if(totalAmmount > paid_total.replace(/,/g, '')){
									vue.$set(vue, 'paid', false);
								}else{
									vue.$set(vue, 'paid', true);
								}
							}
						}

						if(paid_total.replace(/,/g, '') > 0){ 
							paid_total = paid_total.replace(/,/g, '');
						}

						var change    = 0;
						if(paid_total > 0){
							change    = (paid_total - totalAmmount);
						}
						    
						var remaining = 0;
						    remaining = (totalAmmount - paid_total);
						
						$("#change_total").val(change);
						$("#remaining_total").val(remaining);
						$("#remaining_total_show").val('-' +remaining);

						vue.$set(vue, 'totalChange', change);
						vue.$set(vue, 'totalRemaining', remaining);
					},

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 2);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},

					handleForm2: function (type) {
						var vue = this;
			
						window.DATETIME.initDatePicker();
			
						$(that.elForm).validate();
			
						$(that.elForm).ajaxForm({
							beforeSend: function () {
							    $("#savebutton").attr('disabled','disabled');
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
			
								if (vue.detailData.length == 0) {
									toastr.warning('Silahkan isi data terlebih dahulu!')
									$("#savebutton").removeAttr("disabled");
									$(that.elVue).unblock();
									return false;
								}

								// if(that.objectFindByKey(vue.detailData, 'total', '0').length){
								// 	toastr.warning('Silahkan isi Quantity atau Harga terlebih dahulu!')
								// 	$(that.elVue).unblock();
								// 	return false;
								// }
							},
							data: {
								vuedata: vue.detailData
							},
							dataType: "json",
							success: function (response) {
								$(that.elVue).unblock();
								
								window.FORM.showNotification(response.message, response.status);
								if(response.status == "error"){
								    $("#savebutton").removeAttr("disabled");
								}
			
								if (response.status == "success") {
									setTimeout(function () {
									    	window.location.href = that.urlPrintOut + response.id
									    setTimeout(function () {
										window.location.href = that.urlIndex
									    }, 500);
									
									}, 1500);
								}
			
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
					
                    if(id != 'new'){
						vue.handleData();
					}
					vue.handleCheckbox();
					var paymentMethod = $("#payment-method-select").val();
						vue.$set(vue, 'paymentMethod', paymentMethod);
						// vue.handlePayment();
						
					setTimeout(function () {
						// $(that.elForm).validate();

						// $(that.elVue).block({
						// 	message: '<h4>Please Wait..</h4>'
						// });

						that.handleForm();
						
						
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);

						// $(that.elVue).unblock();
					}, 500);
					// console.log(vue.detailData);
					
				}
			});

		},

		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					if (response.status == "success") {
						setTimeout(function () {
							window.location.href = that.urlIndex
						}, 1500);
					}

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);