/**
 * Javascript Embed
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

window.EMBED = (function ($) {
	return {

		initVue: null,
		elVue: '#embed-vue',
		elTable: "#embed-table",
		elClose: '.embed-close',

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		urlGetData: window.APP.siteUrl + 'adm/sales_orders/get_data_embed',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					listData: [],
					a:'',
					iconhpp:'fas fa-eye-slash'
				},
				methods: {
					

					getDataEmbed: function (Event) {
                        var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						var value = $("#search").val();
						var customer = $("#customer-select").val();
						
						$.ajax({
                            url: that.urlGetData,
                            type: 'post',
                            data: {
                                'search': Event,
                                'customer': customer
                            },
							dataType: "json",
							success: function (response) {
								// vue.$set(vue, 'listData', response.data);
								
								var items = response.data;
								var listData = {};

								for (i = 0; i < items.length; i++) {
									var item = items[i];

									var lg_unit     = item.lg_unit;
									var md_unit     = item.md_unit;
									var sm_unit     = item.sm_unit;
									var lg_unit_cnt = item.lg_unit_cnt;
									var md_unit_cnt = item.md_unit_cnt;
									var sm_unit_cnt = item.sm_unit_cnt;
									var lg_unit_qty = 0;
									var md_unit_qty = 0;
									var sm_unit_qty = 0;
									var lg_unit_prc = item.lg_unit_prc;
									var md_unit_prc = item.md_unit_prc;
									var sm_unit_prc = item.sm_unit_prc;
									var lg_unit_hpp = item.lg_unit_hpp;
									var md_unit_hpp = item.md_unit_hpp;
									var sm_unit_hpp = item.sm_unit_hpp;
									var ppn_status = item.ppn_status;
									var ppn_status_color = item.ppn_status_color;
									// var discount = 0;
									// var discount_total = 0;

									var lg_unit_dsc = 0;
									var md_unit_dsc = 0;
									var sm_unit_dsc = 0;

									var result_large = 0;
									var result_medium = 0;
									var result_small = 0;
									var total = 0;
									var total_stock = item.total_stock;
									var total_stock_stored = item.total_stock_stored;

									var overprice_lg = 0;
									var overprice_md = 0;
									var overprice_sm = 0;

									var btncolor = 'btn-default';
									var btnicon = '';

									var bg_min_stock = item.bg_min_stock;
									
									var ttl_stock = 0;
									var ttls_lg   = 0;
									var ttls_md   = 0;
									var ttls_sm   = 0;
									
									ttl_stock = item.total_stock;
									ttls_lg   = (item.lg_unit_cnt == 0 ? '0' : Math.floor(item.total_stock / item.lg_unit_cnt));
									ttl_stok  = (ttl_stock - (ttls_lg * item.lg_unit_cnt));
									ttls_md   = (item.md_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / item.md_unit_cnt));
									ttl_stok  = (ttl_stok - (ttls_md * item.md_unit_cnt));
									ttls_sm   = (item.sm_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / item.sm_unit_cnt));

									var lg_unit_qtys = 0;
									var md_unit_qtys = 0;
									var sm_unit_qtys = 0;

									if (vue.checkValue_isExists(item.id, vue.a) == 'Exist') {
										btncolor = 'btn-success';
										btnicon = 'fa fa-check';
										index = editVueInit.detailData.map(function (item) {
											return item.id
										}).indexOf(item.id);

										lg_unit_qty = editVueInit.detailData[index].lg_unit_qty;
										md_unit_qty = editVueInit.detailData[index].md_unit_qty;
										sm_unit_qty = editVueInit.detailData[index].sm_unit_qty;


										lg_unit_prc = editVueInit.detailData[index].lg_unit_prc;
										md_unit_prc = editVueInit.detailData[index].md_unit_prc;
										sm_unit_prc = editVueInit.detailData[index].sm_unit_prc;

										lg_unit_dsc = editVueInit.detailData[index].lg_unit_dsc;
										md_unit_dsc = editVueInit.detailData[index].md_unit_dsc;
										sm_unit_dsc = editVueInit.detailData[index].sm_unit_dsc;

										ppn_status = editVueInit.detailData[index].ppn_status;
										ppn_status_color = editVueInit.detailData[index].ppn_status_color;
										bg_min_stock = editVueInit.detailData[index].bg_min_stock;
										// discount = editVueInit.detailData[index].discount;
										// discount_total = editVueInit.detailData[index].discount_total;
										result_large = editVueInit.detailData[index].result_large;
										result_medium = editVueInit.detailData[index].result_medium;
										result_small = editVueInit.detailData[index].result_small;
										total = editVueInit.detailData[index].total;
										total_stock = editVueInit.detailData[index].total_stock;
										total_stock_stored = editVueInit.detailData[index].total_stock_stored;

										overprice_lg = editVueInit.detailData[index].overprice_lg;
										overprice_md = editVueInit.detailData[index].overprice_md;
										overprice_sm = editVueInit.detailData[index].overprice_sm;

										ttls_lg = editVueInit.detailData[index].ttls_lg;
										ttls_md = editVueInit.detailData[index].ttls_md;
										ttls_sm = editVueInit.detailData[index].ttls_sm;

										lg_unit_qtys = editVueInit.detailData[index].lg_unit_qtys;
										md_unit_qtys = editVueInit.detailData[index].md_unit_qtys;
										sm_unit_qtys = editVueInit.detailData[index].sm_unit_qtys;
									}
									listData[i] = {
										'no'              : item.no,
										'id'              : item.id,
										'name'            : item.name,
										'warehouse'       : item.warehouse_id,
										'group_name'      : item.group_name,
										'group_child_name': item.group_child_name,
										'lg_unit'         : lg_unit,
										'lg_unit_cnt'     : lg_unit_cnt,
										'lg_unit_qty'     : lg_unit_qty,
										'lg_unit_prc'     : lg_unit_prc,
										'lg_unit_prc2'     : lg_unit_prc,
										'lg_unit_prc_list'     : item.lg_unit_prc,
										'lg_unit_hpp'     : lg_unit_hpp,
										'md_unit'         : md_unit,
										'md_unit_cnt'     : md_unit_cnt,
										'md_unit_qty'     : md_unit_qty,
										'md_unit_prc'     : md_unit_prc,
										'md_unit_prc2'     : md_unit_prc,
										'md_unit_hpp'     : md_unit_hpp,
										'sm_unit'         : sm_unit,
										'sm_unit_cnt'     : sm_unit_cnt,
										'sm_unit_qty'     : sm_unit_qty,
										'sm_unit_prc'     : sm_unit_prc,
										'sm_unit_prc2'     : sm_unit_prc,
										'sm_unit_hpp'     : sm_unit_hpp,

										'lg_unit_dsc' : lg_unit_dsc,
										'md_unit_dsc' : md_unit_dsc,
										'sm_unit_dsc' : sm_unit_dsc,
										'discount'        : 0,
										'discount_total'        : 0,
										'result_large'      : result_large,
										'result_medium'     : result_medium,
										'result_small'      : result_small,
										'total'             : total,
										'minimum_stock'        : item.minimum_stock,
										'ppn_status'        : ppn_status,
										'ppn_status_color'  : ppn_status_color,
										'total_stock'       : total_stock,
										'total_stock_stored': total_stock_stored,
										'remark'            : '',

										'overprice_lg'         : overprice_lg,
										'overprice_md'         : overprice_md,
										'overprice_sm'         : overprice_sm,

										'btncolor'    : btncolor,
										'btnicon'     : btnicon,
										'bg_min_stock': bg_min_stock,

										'ttls_lg': ttls_lg,
										'ttls_md': ttls_md,
										'ttls_sm': ttls_sm,
										
										'ttls_lg_gd1': item.total_stock_gd1,
										'ttls_md_gd1': item.total_stock_sedang_gd1,
								// 		'ttls_sm': ttls_sm,
										'ttls_lg_gd2': item.total_stock_gd2,
										'ttls_md_gd2': item.total_stock_sedang_gd2,
								// 		'ttls_sm': ttls_sm,
										'ttls_lg_gd3': item.total_stock_gd3,
										'ttls_md_gd3': item.total_stock_sedang_gd3,
								// 		'ttls_sm': ttls_sm,

										'lg_unit_qtys' : lg_unit_qtys,
										'md_unit_qtys' : md_unit_qtys,
										'sm_unit_qtys' : sm_unit_qtys

									};
								}
								vue.listData = listData;
							}
						});
					},

					getSelectedData: function (row, idx) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							// toastr.warning('Data sudah tersedia!')
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							editVueInit.detailData.splice(index, 1);
							vue.$set(vue.listData[idx], 'btncolor', 'btn-default');
							vue.$set(vue.listData[idx], 'btnicon', '');
						}else{
						    if(row.ttls_lg_gd1 < row.lg_unit_qty){
						        toastr.warning('Stok tidak cukup!');
						    }else if(parseFloat(row.lg_unit_prc.replace(/[^\w\s]/gi, '')) < parseFloat(row.lg_unit_hpp.replace(/[^\w\s]/gi, ''))){
						        toastr.warning('Harga jual lebih rendah dari HPP!');
						    }else{
						        	editVueInit.detailData.push({
        								id: row.id,
        								name: row.name,
        								warehouse: 5,
        								lg_unit         : row.lg_unit,
        								lg_unit_cnt     : row.lg_unit_cnt,
        								lg_unit_qty     : row.lg_unit_qty,
        								lg_unit_prc     : row.lg_unit_prc,
        								lg_unit_prc2     : row.lg_unit_prc,
        								lg_unit_hpp     : row.lg_unit_hpp,
        								md_unit         : row.md_unit,
        								md_unit_cnt     : row.md_unit_cnt,
        								md_unit_qty     : row.md_unit_qty,
        								md_unit_prc     : row.md_unit_prc,
        								md_unit_prc2     : row.md_unit_prc,
        								md_unit_hpp     : row.md_unit_hpp,
        								sm_unit         : row.sm_unit,
        								sm_unit_cnt     : row.sm_unit_cnt,
        								sm_unit_qty     : row.sm_unit_qty,
        								sm_unit_prc     : row.sm_unit_prc,
        								sm_unit_prc2     : row.sm_unit_prc,
        								sm_unit_hpp     : row.sm_unit_hpp,
        
        								lg_unit_dsc: row.lg_unit_dsc,
        								md_unit_dsc: row.md_unit_dsc,
        								sm_unit_dsc: row.sm_unit_dsc,
        
        								discount        : row.discount,
        								discount_total        : row.discount_total,
        								result_large      : row.result_large,
        								result_medium     : row.result_medium,
        								result_small      : row.result_small,
        								total             : row.total,
        								minimum_stock         : row.minimum_stock,
        								ppn_total         : row.ppn_total,
        								ppn_status        : row.ppn_status,
        								ppn_status_color  : row.ppn_status_color,
        								bg_min_stock  : row.bg_min_stock,
        								total_stock       : row.total_stock,
        								total_stock_stored: row.total_stock_stored,
        
        								overprice_lg         : row.overprice_lg,
        								overprice_md         : row.overprice_md,
        								overprice_sm         : row.overprice_sm,
        
        								ttls_lg: row.ttls_lg,
        								ttls_lg_gd1: row.ttls_lg_gd1,
        								ttls_md: row.ttls_md,
        								ttls_sm: row.ttls_sm,
        
        								lg_unit_qtys: row.lg_unit_qtys,
        								md_unit_qtys: row.md_unit_qtys,
        								sm_unit_qtys: row.sm_unit_qtys,
        
        								remark: ''
        							});
        							vue.$set(vue.listData[idx], 'btncolor', 'btn-success');
        							vue.$set(vue.listData[idx], 'btnicon', 'fa fa-check');
						    }
						
						}
						
						vue.checkData_isExists();
						$("#search").focus();
						$("#search").val("");
					},

					countSubTotal: function () {
						var vue = this;


						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						

						var totalAmmount = 0;
						var items = editVueInit.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						
						}
						
						return totalAmmount.toLocaleString("en-US");
					},

					hppShow: function () {
						var vue = this;
						
						var t = $(".output-hpp").attr('type');
						if(t == 'text'){
							$(".output-hpp").attr('type', 'password');
							vue.$set(vue, 'iconhpp', 'fas fa-eye-slash');

						}else{
							$(".output-hpp").attr('type', 'text');
							vue.$set(vue, 'iconhpp', 'fas fa-eye');							

						}
					},

					handlePrice: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						vue.$set(row, field_name, value);

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
						}

						var overprice_lg = 0;
						var overprice_md = 0;
						var overprice_sm = 0;
						if(field_name == 'lg_unit_prc'){
							if(parseFloat(row.lg_unit_prc.replace(/[^\w\s]/gi, '')) < parseFloat(row.lg_unit_hpp.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga jual lebih rendah dari HPP!');
								// vue.$set(row, 'lg_unit_prc', row.lg_unit_prc2.toLocaleString("en-US"));
								vue.$set(row, 'overprice_lg', 1);
							}else{
								vue.$set(row, 'overprice_lg', 0);
							}
						}

						if(field_name == 'md_unit_prc'){
							if(parseFloat(row.md_unit_prc.replace(/[^\w\s]/gi, '')) < parseFloat(row.md_unit_hpp.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga jual lebih rendah dari HPP!');
								// vue.$set(row, 'md_unit_prc', row.md_unit_prc2.toLocaleString("en-US"));
								vue.$set(row, 'overprice_md', 1);
							}else{
								vue.$set(row, 'overprice_md', 0);
							}
						}

						if(field_name == 'sm_unit_prc'){
							if(parseFloat(row.sm_unit_prc.replace(/[^\w\s]/gi, '')) < parseFloat(row.sm_unit_hpp.replace(/[^\w\s]/gi, ''))){
								toastr.warning('Harga jual lebih rendah dari HPP!');
								// vue.$set(row, 'sm_unit_prc', row.sm_unit_prc2.toLocaleString("en-US"));
								vue.$set(row, 'overprice_sm', 1);
							}else{
								vue.$set(row, 'overprice_sm', 0);
							}
						}

						vue.handleCount(row, field_name, value);
					},

					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						var price_large = 0;
						var price_medium = 0;
						var price_small = 0;
						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc' || field_name == 'lg_unit_dsc') {
							var no_dsc = row.lg_unit_prc.replace(/[^\w\s]/gi, '');
							var is_dsc = (row.lg_unit_dsc != 0 ? row.lg_unit_dsc.replace(/[^\w\s]/gi, '') : row.lg_unit_dsc);
							var af_dsc = (Number(no_dsc) - Number(is_dsc));

							price_large = (is_dsc > 0 ? af_dsc : no_dsc);

							result_large = (row.lg_unit_qty * price_large);
							
							vue.$set(row, 'result_large', result_large);
							if (field_name == 'lg_unit_qty' && wholesale_done != 1) {
								// vue.handleWholesalePrice(row, field_name, value);
								// vue.handleStock(row, field_name, value);
							}
						
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc' || field_name == 'md_unit_dsc' ) {
							var no_dsc = row.md_unit_prc.replace(/[^\w\s]/gi, '');
							var is_dsc = (row.md_unit_dsc != 0 ? row.md_unit_dsc.replace(/[^\w\s]/gi, '') : row.md_unit_dsc);
							var af_dsc = (Number(no_dsc) - Number(is_dsc));

							price_medium = (is_dsc > 0 ? af_dsc : no_dsc);

							result_medium = (row.md_unit_qty * price_medium);

							vue.$set(row, 'result_medium', result_medium);
				// 			vue.handleStock(row, field_name, value);
							
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc' || field_name == 'sm_unit_dsc') {
							var no_dsc = row.sm_unit_prc.replace(/[^\w\s]/gi, '');
							var is_dsc = (row.sm_unit_dsc != 0 ? row.sm_unit_dsc.replace(/[^\w\s]/gi, '') : row.sm_unit_dsc);
							var af_dsc = (Number(no_dsc) - Number(is_dsc));

							price_small = (is_dsc > 0 ? af_dsc : no_dsc);

							result_small = (row.sm_unit_qty * price_small);

							vue.$set(row, 'result_small', result_small);
				// 			vue.handleStock(row, field_name, value);
						
						}

						result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(result_large_total) + Number(result_medium_total) + Number(result_small_total));

						discount = total * row.discount / 100;
						sub_total = total - discount;
						
						var ppn_total = 0
						if(row.ppn_status == '2'){
							var ppn_amount = $("#ppn_amount").val();
							    ppn_total  = (total * (ppn_amount/100));
						}
						vue.$set(row, 'ppn_total', ppn_total);
						vue.$set(row, 'total', (sub_total + ppn_total).toLocaleString("en-US"));
						// vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							// This is the KEY : To Restore If Sometimes Get Error's
							vue.$set(editVueInit.detailData[index], field_name, value);

							vue.$set(editVueInit.detailData[index], 'lg_unit_prc', row.lg_unit_prc);
							vue.$set(editVueInit.detailData[index], 'md_unit_prc', row.md_unit_prc);
							vue.$set(editVueInit.detailData[index], 'sm_unit_prc', row.sm_unit_prc);

							vue.$set(editVueInit.detailData[index], 'result_large', result_large_total);
							vue.$set(editVueInit.detailData[index], 'result_medium', result_medium_total);
							vue.$set(editVueInit.detailData[index], 'result_small', result_small_total);
							// vue.$set(editVueInit.detailData[index], 'discount_total', discount.toLocaleString("en-US"));
							// vue.$set(editVueInit.detailData[index], 'total', sub_total.toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'total', (total + ppn_total).toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'ppn_total', ppn_total);

							vue.$set(editVueInit.detailData[index], 'overprice_lg', row.overprice_lg);
							vue.$set(editVueInit.detailData[index], 'overprice_md', row.overprice_md);
							vue.$set(editVueInit.detailData[index], 'overprice_sm', row.overprice_sm);
						}

						var ttl_stock = 0;
						var ttls_lg = 0;
						var ttls_md = 0;
						var ttls_sm = 0;
						
						ttl_stock = row.total_stock;
						ttls_lg   = (row.lg_unit_cnt == 0 ? '0' : Math.floor(row.total_stock / row.lg_unit_cnt));
						ttl_stok  = (ttl_stock - (ttls_lg * row.lg_unit_cnt));
						ttls_md   = (row.md_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / row.md_unit_cnt));
						ttl_stok  = (ttl_stok - (ttls_md * row.md_unit_cnt));
						ttls_sm   = (row.sm_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / row.sm_unit_cnt));
						vue.$set(row, 'ttls_lg', ttls_lg);
						vue.$set(row, 'ttls_md', ttls_md);
						vue.$set(row, 'ttls_sm', ttls_sm);
					},

					handleWholesalePrice: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_wholesale_price',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								quantity_large: value
							},
							success: function (data) {
								vue.$set(row, 'lg_unit_prc', data);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},

					handleStock: function(row, field_name, value) {
						var vue = this;
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						lg_calc = 0;
						md_calc = 0;
						sm_calc = 0;

						calc = row.total_stock_stored;
						calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

						if(calc < 0){
							toastr.warning('Stok tidak mencukupi!');
							if(field_name == 'lg_unit_qty'){
								vue.$set(row, 'lg_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								// vue.handleCount(row, field_name, value);
							}
							if(field_name == 'md_unit_qty'){
								vue.$set(row, 'md_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								// vue.handleCount(row, field_name, value);
							}
							if(field_name == 'sm_unit_qty'){
								vue.$set(row, 'sm_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								// vue.handleCount(row, field_name, value);
							}
						}

						

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], 'total_stock', calc);
						}
						
						var left_stock_large = 0;
						left_stock_large = (calc/row.lg_unit_cnt);

						if(left_stock_large <= row.minimum_stock){
							toastr.error('Barang telah mencapai stok minimum!')
							vue.$set(row, 'bg_min_stock', 'bg-danger');
						}else{
							vue.$set(row, 'bg_min_stock', '');
						}

						vue.$set(row, 'total_stock', calc);
						
					},

					closeModal: function () {
						$(that.elClose).click();
					},

					checkData_isExists: function () {
						var vue = this;

						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						const a = [];
						const objectArray = Object.entries(editVueInit.detailData);

						objectArray.forEach(([key, value]) => {
							a.push(value.id);
						});

						vue.a = a;
					},	

					checkValue_isExists: function (value, arr) {
						var vue = this;

						var status = 'Not exist';

						for (var i = 0; i < arr.length; i++) {
							var contains = arr[i];
							if (contains == value) {
								status = 'Exist';
								break;
							}
						}

						return status;
					}
				},
				mounted: function () {
					var vue = this;

					vue.getDataEmbed();
					vue.checkData_isExists();
					
				}
			});

		},

		handleSearch: function(elDivID)
		{	
			var that = this;

			var typingTimer;
			var doneTypingInterval = 1000;
			var inputKeyup = $(elDivID);
			$(inputKeyup).keyup(function() {
				var Ide = this.value;
				clearTimeout(typingTimer);
			    if (Ide != "") {
			        typingTimer = setTimeout(doneTyping, doneTypingInterval);
			    }else{
			    	console.log(NULL);
			    }

				function doneTyping () {
					that.initVue.getDataEmbed(Ide);
				}
			});
		},
	}
})(jQuery);