/**
 * Javascript Edit
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
window.FORM_EDIT = (function ($) {
	return {

		// vue
		initVue: null,
		elVue: "#vue-edit",
		elTable: "#edit-table",

		// form
		elForm: ".edit-form",
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",
		elInputMask: ".inputmasknumber",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		// url
        urlPrintOut: window.APP.siteUrl + 'adm/sales_orders/export_excel/',
        urlIndex: window.APP.siteUrl + 'adm/sales_orders/',
        urlList: window.APP.siteUrl + 'adm/sales_orders/get_embed',
        urlListStatus: window.APP.siteUrl + 'adm/sales_orders/get_embed_status',
        urlRequestData: window.APP.siteUrl + 'adm/sales_orders/get_data_detail',
        urlRequestData2: window.APP.siteUrl + 'adm/sales_orders/get_data_detail2',
        urlDeleteData: window.APP.siteUrl + 'adm/sales_orders/delete_item',

		// initial
		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					detailData: [],
					detailFilterData: [],
					paymentMethod: '',
					ppn_status_color: '',
					paid: false,
					totalRemaining: 0,
					totalChange: 0,
					overprice: '',
				},
				methods: {
					detailAdd: function () {
						// show modal
						var customer = $("#customer-select").val();

						if(customer == ""){
							toastr.warning('Silahkan pilih pelanggan terlebih dahulu!')
						}else{
							$(that.elModal).modal("show");
							$.ajax({
								url: that.urlList,
								success: function (response) {
									$(that.elModalC).html(response);
								}
							});
						}

						$('input[type="checkbox"]').prop('checked', false);
					},
						detailAddStatus: function () {
						// show modal
						var vue = this;

							$(that.elModal).modal("show");
							let filteredArray = vue.detailData.filter(function (item) {
                              return item.ppn_status == 2;
                            });
                            
                            // Sort the filtered array based on the id property (for example)
                            filteredArray.sort(function (a, b) {
                              return a.id - b.id;
                            });
                            // filteredArray.forEach(function (item) {
                            //     price_large = item.lg_unit_prc.replace(/[^\w\s]/gi, '');
                            //     price_medium = item.md_unit_prc.replace(/[^\w\s]/gi, '');
                            //     price_small = item.sm_unit_prc.replace(/[^\w\s]/gi, '');
                            //   price_large *= 1.11; // Increase the price by 11%
                            //   price_medium *= 1.11; // Increase the price by 11%
                            //   price_small *= 1.11; // Increase the price by 11%
                            //   item.lg_unit_prc = price_large.toLocaleString("en-US");
                            //   item.md_unit_prc = price_medium.toLocaleString("en-US");
                            //   item.sm_unit_prc = price_small.toLocaleString("en-US");
                            // });
                            
                            vue.$set(vue, 'detailFilterData', filteredArray);
                            
                            
							$.ajax({
								url: that.urlListStatus,
								success: function (response) {
									$(that.elModalC).html(response);
								}
							});
				// 		}

						$('input[type="checkbox"]').prop('checked', false);
					},

					detailDelete: function () {
						var vue = this;
						var rows = [];
						var arr = vue.detailData;
						// var tr = document.getElementById("table-edit").getElementsByTagName("tr").length;

						// mencari checkbox yg diselect
						var items = $(that.elTable).find('input[class="check-sub"]:checked');
						for (var i = 0; i < items.length; i++) {
							rows.push($(items[i]).val());
						}

						// jika tidak ada yg dipilih
						// munculkan notif
						// sebaliknya menghapus data
						if (!rows.length) {
							toastr.warning('Silahkan pilih data yang akan dihapus terlebih dahulu!')
						} else {
							// delete array dari data yg dipilih
							var i;
							for (i = 0; i < arr.length; i++) {
								delete arr[rows[i]];
								// this.detailsSatuan.splice(i, 1);
							}


							that.arrayClean(arr, undefined);
							// update vue data
							setTimeout(function () {
								vue.$set(vue, 'detailData', arr);
								var ii = $('input[type="checkbox"]');
								ii.prop('checked', false);

							}, 100);
						}

						$('input[type="checkbox"]').prop('checked', false);
					},
					
					detailDelete2: function (row, idx) {
						var vue = this;
							

							Swal.fire({
								title: 'Anda yakin?',
								text: "Ingin menghapus data ini?",
								type: 'warning',
								showCancelButton: true,
								confirmButtonColor: '#3085d6',
								cancelButtonColor: '#d33',
								confirmButtonText: 'Ya, Hapus!',
								cancelButtonText: 'Batal'
							}).then((result) => {
								if (result.value) {
									$.ajax({
										type: "POST",
										dataType: 'json',
										url: that.urlDeleteData,
										data: {
											id: $("#id").val(),
											item: vue.detailData[idx],
										},
										success: function (response) {
											window.FORM.showNotification(response.message, response.status);
											// parentThis.elDatatable.ajax.reload();
											// console.log("deleted");
											vue.detailData.splice(idx, 1);
										}
									});
								}
							})	
							
						vue.countSubTotal();
					},

					cekIfZero: function()
					{
						var vue = this;

						// console.log();
						console.log(that.objectFindByKey(vue.detailData, 'total', '0').length);
					},

                    handleData: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
                    		  //  console.log(response);
                    		 // Map the array and update prices for items with status 2
                                let updatedArray = response.map(function (item) {
                                  if (item.status === 2) {
                                    // Increase the price by 11%
                                    return { ...item, price: item.price * 1.11 };
                                  } else {
                                    return item;
                                  }
                                });
                                
                                // Sort the updated array by status, and within that, by id
                                updatedArray.sort(function (a, b) {
                                  // First, sort by status
                                  if (a.status !== b.status) {
                                    return a.status - b.status;
                                  }
                                
                                  // If status is equal (both are 2), then sort by id
                                  return a.id - b.id;
                                });
                                
                                console.log("Original array:", response);
                                console.log("Updated and sorted array:", updatedArray);
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
					},

					handleData2: function () {
                    	var vue = this;
                    	var id = $("#id").val();

                    	$.ajax({
                    		url: that.urlRequestData2,
                    		type: 'post',
                    		data: {
                    			'id': id
                    		},
							dataType: "json",
							beforeSend: function () {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
                    		success: function (response) {
								vue.$set(vue, 'detailData', response);
								$(that.elVue).unblock();
                    		}
                    	});
					},
					
					handleDsc: function (row) {
						var vue = this;

						// console.log(row);
					},

					handlePayment: function () {
						var vue = this;
						
						$("#payment-method-select").change(function (e) {
							var payment_method = $(e.target).val();
							var customer = $("#customer-select").val();
							var sales_order_date = $("#sales-order-date").val();

							if (customer != "") {
								if (payment_method === "Kredit") {
									vue.handleServicesPayment(customer, sales_order_date);
									vue.$set(vue, 'paymentMethod', payment_method);
								}
								if (payment_method === "Tunai") {
									vue.handleResetPayment();
									vue.$set(vue, 'paymentMethod', payment_method);
								}
							} else {
								toastr.warning('Silahkan pilih Pelanggan terlebih dahulu!');
							}

							setTimeout(function () {
								vue.handlePaid();
							}, 100)
							
						});

				// 		var previousValue;
				// 		$("#customer-select").on('focus', function (e) {
				// 			previousValue = this.value;
				// 		}).change(function () {
				// 			var customer = $(this).val();
				// 			var payment_method = $("#payment-method-select").val();
				// 			var sales_order_date = $("#sales-order-date").val();

				// 			var storedPreviousValue = previousValue;
				// 			if (payment_method == 'Kredit') {
				// 				vue.handleServicesPayment(customer, sales_order_date);
				// 			} else {
				// 				vue.handleResetPayment();
				// 			}

				// 			if (vue.detailData.length > 0) {

				// 				Swal.fire({
				// 					title: 'Anda yakin ingin mengganti Pelanggan?',
				// 					text: "Data item akan direset",
				// 					type: 'warning',
				// 					showCancelButton: true,
				// 					confirmButtonColor: '#3085d6',
				// 					cancelButtonColor: '#d33',
				// 					confirmButtonText: 'Ya, Lanjut!',
				// 					cancelButtonText: 'Batal'
				// 				}).then((result) => {
				// 					if (result.value) {
				// 						vue.detailData.splice(0, vue.detailData.length);
				// 					} else if (result.dismiss == 'cancel') {
										
				// 						if (previousValue != undefined) {
				// 							$("#customer-select").val(storedPreviousValue).trigger('change.select2');
				// 						}
				// 						previousValue = storedPreviousValue;
				// 					}
				// 				})

				// 			}

				// 			previousValue = this.value;
				// 			vue.$set(vue, 'paymentMethod', payment_method);
				// 		});

					},
					handlePayment2: function () {
						var vue = this;
						
						$("#payment-method-select").change(function (e) {
							var payment_method = $(e.target).val();
							var customer = $("#customer-select").val();
							var sales_order_date = $("#sales-order-date").val();

							if (customer != "") {
								if (payment_method === "Kredit") {
									vue.handleServicesPayment(customer, sales_order_date);
									vue.$set(vue, 'paymentMethod', payment_method);
								}
								if (payment_method === "Tunai") {
									vue.handleResetPayment();
									vue.$set(vue, 'paymentMethod', payment_method);
								}
							} else {
								toastr.warning('Silahkan pilih Pelanggan terlebih dahulu!');
							}

							setTimeout(function () {
								vue.handlePaid();
							}, 100)
							
						});

				// 		var previousValue;
				// 		$("#customer-select").on('focus', function (e) {
				// 			previousValue = this.value;
				// 		}).change(function () {
				// 			var customer = $(this).val();
				// 			var payment_method = $("#payment-method-select").val();
				// 			var sales_order_date = $("#sales-order-date").val();

				// 			var storedPreviousValue = previousValue;
				// 			if (payment_method == 'Kredit') {
				// 				vue.handleServicesPayment(customer, sales_order_date);
				// 			} else {
				// 				vue.handleResetPayment();
				// 			}

				// 			if (vue.detailData.length > 0) {

				// 				Swal.fire({
				// 					title: 'Anda yakin ingin mengganti Pelanggan?',
				// 					text: "Data item akan direset",
				// 					type: 'warning',
				// 					showCancelButton: true,
				// 					confirmButtonColor: '#3085d6',
				// 					cancelButtonColor: '#d33',
				// 					confirmButtonText: 'Ya, Lanjut!',
				// 					cancelButtonText: 'Batal'
				// 				}).then((result) => {
				// 					if (result.value) {
				// 						vue.detailData.splice(0, vue.detailData.length);
				// 					} else if (result.dismiss == 'cancel') {
										
				// 						if (previousValue != undefined) {
				// 							$("#customer-select").val(storedPreviousValue).trigger('change.select2');
				// 						}
				// 						previousValue = storedPreviousValue;
				// 					}
				// 				})

				// 			}

				// 			previousValue = this.value;
				// 			vue.$set(vue, 'paymentMethod', payment_method);
				// 		});

					},

					handleServicesPayment: function (customer, sales_order_date) {
						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_payment_term',
							dataType: "JSON",
							data: {
								customer: customer,
								sales_order_date: sales_order_date
							},
							success: function (data) {
								$("#payment-term-text").val(data.payment_term);
								$("#payment-due-text").val(data.payment_due);
							},
						});
					},

					handlePaymentByDays: function (Event) {
						var sales_order_date = $("#sales-order-date").val();

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_payment_term_by_days',
							dataType: "JSON",
							data: {
								payment_term: Event,
								sales_order_date: sales_order_date
							},
							success: function (data) {
								$("#payment-due-text").val(data.payment_due);
							},
						});
					},

					handleResetPayment: function () {
						$("#payment-term-text").val("");
						$("#payment-due-text").val("");
					},

					handlePrice: function(row, field_name, value) {
						var vue = this;
						
						
                        if(field_name == 'lg_unit_prc' || field_name == 'md_unit_prc' || field_name == 'sm_unit_prc'){
                            setTimeout(function () {
    							window.INPUT.handleMaskCurrency();
    						}, 100);
                        }
						
						
						vue.$set(row, field_name, value);
						vue.handleCount(row, field_name, value);

						if(field_name == 'lg_unit_prc'){
							if(parseFloat(row.lg_unit_prc.replace(/[^\w\s]/gi, '')) < parseFloat(row.lg_unit_hpp.replace(/[^\w\s]/gi, ''))){
								// toastr.warning('Harga jual lebih rendah dari HPP!');
								// toastr.warning('Harga jual lebih rendah dari HPP!', '', {
        //                             timeOut: 500,
        //                             extendedTimeOut: 500
        //                         });
								// vue.$set(row, 'lg_unit_prc', row.lg_unit_prc2.toLocaleString("en-US"));
								vue.$set(row, 'overprice_lg', 0);
							}else{
								vue.$set(row, 'overprice_lg', 0);
							}
						}

						if(field_name == 'md_unit_prc'){
							if(parseFloat(row.md_unit_prc.replace(/[^\w\s]/gi, '')) < parseFloat(row.md_unit_hpp.replace(/[^\w\s]/gi, ''))){
								// toastr.warning('Harga jual lebih rendah dari HPP!', '', {
        //                             timeOut: 500,
        //                             extendedTimeOut: 500
        //                         });
								// // vue.$set(row, 'md_unit_prc', row.md_unit_prc2.toLocaleString("en-US"));
								vue.$set(row, 'overprice_md', 0);
							}else{
								vue.$set(row, 'overprice_md', 0);
							}
						}

						if(field_name == 'sm_unit_prc'){
							if(parseFloat(row.sm_unit_prc.replace(/[^\w\s]/gi, '')) < parseFloat(row.sm_unit_hpp.replace(/[^\w\s]/gi, ''))){
								// toastr.warning('Harga jual lebih rendah dari HPP!');
								// vue.$set(row, 'sm_unit_prc', row.sm_unit_prc2.toLocaleString("en-US"));
								vue.$set(row, 'overprice_sm', 0);
							}else{
								vue.$set(row, 'overprice_sm', 0);
							}
						}
					},

					countOverprice: function () {
						var vue = this;

						var grandTotal = 0;
						var totalAmmountLg = 0;
						var totalAmmountMd = 0;
						var totalAmmountSm = 0;
						var items = vue.detailData;

						// console.log(vue.detailData);
						for (var i in items) {
							totalAmmountLg += (Number(items[i].overprice_lg));
							totalAmmountMd += (Number(items[i].overprice_md));
							totalAmmountSm += (Number(items[i].overprice_sm));
						}
						
						grandTotal = (totalAmmountLg + totalAmmountMd + totalAmmountSm);

						if(Number(grandTotal) > 0){
							vue.$set(vue, 'overprice', 'bg-danger');
						}else{
							vue.$set(vue, 'overprice', '');
						}

						return Number(grandTotal);
					},

					handlePPNStatus: function(row, fieldname, value) {
						var vue = this;
						var total = 0;
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));

						var ppn_total = 0
						if(row.ppn_status == '2'){
							ppn_total = (total * 0.10);
							vue.$set(row, 'ppn_status_color', 'bg-success');
						}else if(row.ppn_status == '1'){
							ppn_total = 0;
							vue.$set(row, 'ppn_status_color', '');
						}else{
							ppn_total = 0;
							vue.$set(row, 'ppn_status_color', 'bg-warning');
						}
						vue.$set(row, 'ppn_total', ppn_total);
						vue.$set(row, 'total', (total + ppn_total).toLocaleString("en-US"));
					},
					
					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;

						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc' || field_name == 'lg_unit_dsc') {
							var no_dsc = row.lg_unit_prc.replace(/[^\w\s]/gi, '');
							var is_dsc = (row.lg_unit_dsc != 0 ? row.lg_unit_dsc.replace(/[^\w\s]/gi, '') : row.lg_unit_dsc);
							var af_dsc = (Number(no_dsc) - Number(is_dsc));

							price_large = (is_dsc > 0 ? af_dsc : no_dsc);

							result_large = (row.lg_unit_qty * price_large);
							vue.$set(row, 'result_large', result_large);
							if (field_name == 'lg_unit_qty' && wholesale_done != 1) {
								// vue.handleWholesalePrice(row, field_name, value);
								vue.handleStock(row, field_name, value);
							}
						
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc' || field_name == 'md_unit_dsc' ) {
							var no_dsc = row.md_unit_prc.replace(/[^\w\s]/gi, '');
							var is_dsc = (row.md_unit_dsc != 0 ? row.md_unit_dsc.replace(/[^\w\s]/gi, '') : row.md_unit_dsc);
							var af_dsc = (Number(no_dsc) - Number(is_dsc));

							price_medium = (is_dsc > 0 ? af_dsc : no_dsc);

							result_medium = (row.md_unit_qty * price_medium);
							vue.$set(row, 'result_medium', result_medium);
							vue.handleStock(row, field_name, value);
							
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc' || field_name == 'sm_unit_dsc') {
							var no_dsc = row.sm_unit_prc.replace(/[^\w\s]/gi, '');
							var is_dsc = (row.sm_unit_dsc != 0 ? row.sm_unit_dsc.replace(/[^\w\s]/gi, '') : row.sm_unit_dsc);
							var af_dsc = (Number(no_dsc) - Number(is_dsc));

							price_small = (is_dsc > 0 ? af_dsc : no_dsc);

							result_small = (row.sm_unit_qty * price_small);
							vue.$set(row, 'result_small', result_small);
							vue.handleStock(row, field_name, value);
							
						}

						// result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						// result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						// result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(row.result_large) + Number(row.result_medium) + Number(row.result_small));

						var ppn_total = 0
						if(row.ppn_status == '2'){
							// ppn_total = (total * 0.10);
							var ppn_amount = $("#ppn_amount").val();
							    ppn_total  = Math.floor(total * (ppn_amount/100));
						}
						vue.$set(row, 'ppn_total', ppn_total);
						
						if (field_name == 'discount') {
						    discount = total * row.discount / 100;
						    hargadiskon = row.lg_unit_prc.replace(/[^\w\s]/gi, '') * row.discount / 100;
						    hargasetelahdiskon = row.lg_unit_prc.replace(/[^\w\s]/gi, '') - hargadiskon;
						    console.log(hargasetelahdiskon);
						    
						    if(parseFloat(hargasetelahdiskon) < parseFloat(row.lg_unit_hpp.replace(/[^\w\s]/gi, ''))){
						        toastr.warning('Harga jual lebih rendah dari HPP!', '', {
                                    timeOut: 500,
                                    extendedTimeOut: 500
                                });
						  //  	toastr.warning('Harga jual lebih rendah dari HPP!');
						    	discount = 0;
    							vue.$set(row, 'discount', 0);
    							vue.$set(row, 'overprice_lg', 0);
    						}else{
    							vue.$set(row, 'overprice_lg', 0);
    						}
                        }else if(field_name == "discount_total"){
                            discount = row.discount_total.replace(/[^\w\s]/gi, '');
                            // 20000:100000*100 =
                            
                            discount_percent = (row.discount_total.replace(/[^\w\s]/gi, '')) / total * 100;
                            hargadiskon = row.lg_unit_prc.replace(/[^\w\s]/gi, '') * discount_percent / 100;
                            console.log(hargadiskon);
                            hargasetelahdiskon = row.lg_unit_prc.replace(/[^\w\s]/gi, '') - hargadiskon;
                            console.log(hargasetelahdiskon);
                            if(parseFloat(hargasetelahdiskon) < parseFloat(row.lg_unit_hpp.replace(/[^\w\s]/gi, ''))){
						  //  	toastr.warning('Harga jual lebih rendah dari HPP!');
						  toastr.warning('Harga jual lebih rendah dari HPP!', '', {
                                    timeOut: 500,
                                    extendedTimeOut: 500
                                });
    							vue.$set(row, 'discount', 0);
    							vue.$set(row, 'discount_total', 0);
    							vue.$set(row, 'overprice_lg', 0);
    							discount = 0;
    							discount_percent = 0;
    						}else{
    							vue.$set(row, 'overprice_lg', 0);
    						}
                            console.log(discount_percent);
                        }else{
                            discount = total * row.discount / 100;
                            hargadiskon = row.lg_unit_prc.replace(/[^\w\s]/gi, '') * row.discount / 100;
						    hargasetelahdiskon = row.lg_unit_prc.replace(/[^\w\s]/gi, '') - hargadiskon;
						    
						    if(parseFloat(hargasetelahdiskon) < parseFloat(row.lg_unit_hpp.replace(/[^\w\s]/gi, ''))){
						  //  	toastr.warning('Harga jual lebih rendah dari HPP!');
						  toastr.warning('Harga jual lebih rendah dari HPP!', '', {
                                    timeOut: 500,
                                    extendedTimeOut: 500
                                });
    							vue.$set(row, 'discount', 0);
    							vue.$set(row, 'overprice_lg', 0);
    							discount = 0;
    						}else{
    							vue.$set(row, 'overprice_lg', 0);
    						}
                        }
                        
                        
                        
                        
						vue.$set(row, 'total', Math.floor(total + ppn_total - discount).toLocaleString("en-US"));
						
						if (field_name == 'discount') {
        				    vue.$set(row, 'discount_total', Math.floor(discount).toLocaleString("en-US"));
                        }else if(field_name == "discount_total"){
                            vue.$set(row, 'discount', discount_percent.toLocaleString("en-US"));
                        }else{
                            vue.$set(row, 'discount_total', Math.floor(discount).toLocaleString("en-US"));
                        }
						// discount = total * row.discount / 100;
						// sub_total = total - discount;
						// vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						// vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						// This is the KEY : To Restore If Sometimes Get Error's
						// vue.$set(row, field_name, value);

						var ttl_stock = 0;
						var ttls_lg = 0;
						var ttls_md = 0;
						var ttls_sm = 0;
						
						ttl_stock = row.total_stock;
						ttls_lg   = (row.lg_unit_cnt == 0 ? '0' : Math.floor(row.total_stock / row.lg_unit_cnt));
						ttl_stok  = (ttl_stock - (ttls_lg * row.lg_unit_cnt));
						ttls_md   = (row.md_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / row.md_unit_cnt));
						ttl_stok  = (ttl_stok - (ttls_md * row.md_unit_cnt));
						ttls_sm   = (row.sm_unit_cnt == 0 ? '0' : Math.floor(ttl_stok / row.sm_unit_cnt));
						vue.$set(row, 'ttls_lg', ttls_lg);
						vue.$set(row, 'ttls_md', ttls_md);
						vue.$set(row, 'ttls_sm', ttls_sm);
					},

					handleWholesalePrice: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_wholesale_price',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								quantity_large: value
							},
							success: function (data) {
								vue.$set(row, 'lg_unit_prc', data);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},

					handleStock: function(row, field_name, value) {
						var vue = this;

						lg_calc = 0;
						md_calc = 0;
						sm_calc = 0;

						calc = row.ttls_lg_gd1;
						calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

						if(calc < 0){
							toastr.warning('Stok tidak mencukupi! sisa stok:'+row.ttls_lg_gd1);
							if(field_name == 'lg_unit_qty'){
								vue.$set(row, 'lg_unit_qty', 0);
								calc = (row.ttls_lg_gd1 - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'md_unit_qty'){
								vue.$set(row, 'md_unit_qty', 0);
								calc = (row.ttls_lg_gd1 - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
							if(field_name == 'sm_unit_qty'){
								vue.$set(row, 'sm_unit_qty', 0);
								calc = (row.ttls_lg_gd1 - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								vue.handleCount(row, field_name, value);
							}
						}
						
						var left_stock_large = 0;
						left_stock_large = (calc/row.lg_unit_cnt);

						if(left_stock_large <= row.minimum_stock){
							toastr.error('Barang telah mencapai stok minimum!')
							vue.$set(row, 'bg_min_stock', 'bg-danger');
						}else{
							vue.$set(row, 'bg_min_stock', '');
						}
						
						vue.$set(row, 'total_stock', calc);
					},
					countDiscount: function () {
						var vue = this;
                        vue.countSubTotal();
                        console.log("HANDLE DISCOUNT: "+vue.countSubTotal());
					},

					countSubTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var grand_total = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
					
							
						}
						var ongkos = parseInt($('#ongkos').val().replace(/,/g, ''));
						grand_total = Math.floor(totalAmmount + ongkos);
						console.log("subtotalfunction:"+grand_total);
						$("#grand_total").val(grand_total.toLocaleString("en-US"));
						$("#gtotaltext").html(grand_total.toLocaleString("en-US"));
						vue.handlePaid();
						return grand_total.toLocaleString("en-US");
					},
					
					hitungUlang: function () {
                        var vue = this;
                    
                        var totalAmmount = 0;
                        var grand_total = 0;
                        var items = vue.detailData;
                        // console.log(items);
                        for (var i in items) {
                                    if(parseFloat(items[i].lg_unit_prc.replace(/,/g, '')) < parseFloat(items[i].lg_unit_hpp.replace(/,/g, ''))){
                                        alert("Harga jual lebih kecil daripada HPP barang: "+items[i].name);
                                        return false;
                                    }
                                    
                                 
                                     result_large = items[i].lg_unit_qty * parseFloat(items[i].lg_unit_prc.replace(/,/g, ''));
                                    items[i].result_large = result_large;
                        // 			vue.$set(row, 'result_large', result_large);
                                    result_medium = items[i].md_unit_qty * parseFloat(items[i].md_unit_prc.replace(/,/g, ''));
                                    items[i].result_medium = result_medium;
                                    // result_medium = (row.md_unit_qty * price_medium);
                                    // vue.$set(row, 'result_medium', result_medium);
                                    result_small = items[i].sm_unit_qty * parseFloat(items[i].sm_unit_prc.replace(/,/g, ''));
                                    items[i].result_small = result_small;
                                    // result_small = (row.sm_unit_qty * price_small);
                                    // vue.$set(row, 'result_small', result_small);
                                    total = (Number(result_large) + Number(result_medium) + Number(result_small));
                                    discount = total * items[i].discount / 100;
                                    items[i].discount_total = Math.floor(discount).toLocaleString("en-US");
                                    items[i].total = Math.floor(total - discount).toLocaleString("en-US");
                                    // vue.$set(row, 'total', (total - discount).toLocaleString("en-US"));
                        // 			totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
                                    console.log("Hitungan Ulang: "+items[i].total);
                                    grand_total += Math.floor(total - discount);
                                    $(that.elVue).unblock();
                              
                        }
                        return grand_total.toLocaleString("en-US");
                    },


					countPPNTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.detailData;
						// console.log(items);
						for (var i in items) {
							totalAmmount += parseFloat(items[i].ppn_total);
						}

						return Math.floor(totalAmmount).toLocaleString("en-US");
					},

					handlePaid: function (Event) {
						var vue = this;
						var payment_method = $("#payment-method-select").val();
						var paid_total = $("#paid_total").val();
						var totalAmmount = 0;
						var items = vue.detailData;

						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);

						if(Event != ''){
							if(payment_method == 'Kredit'){
								if(totalAmmount > paid_total.replace(/,/g, '')){
									vue.$set(vue, 'paid', true);
								}else{
									vue.$set(vue, 'paid', false);
								}
							}

							if(payment_method == 'Tunai'){
								if(totalAmmount > paid_total.replace(/,/g, '')){
									vue.$set(vue, 'paid', false);
								}else{
									vue.$set(vue, 'paid', true);
								}
							}
						}

						if(paid_total.replace(/,/g, '') > 0){ 
							paid_total = paid_total.replace(/,/g, '');
						}

						var change    = 0;
						if(paid_total > 0){
							change    = Math.floor(paid_total - totalAmmount);
						}
						    
						var remaining = 0;
						    remaining = Math.floor(totalAmmount - paid_total);
						
						$("#change_total").val(change);
						$("#remaining_total").val(remaining);
						$("#remaining_total_show").val('-' +remaining);

						vue.$set(vue, 'totalChange', change);
						vue.$set(vue, 'totalRemaining', remaining);
					},

					handleCheckbox: function () {

						$('#edit-table').on('click', '#check-sub', function () {
							var row     = ($('#edit-table tr').length - 2);
							var checked = $('#edit-table').find('input[class="check-sub"]:checked');
			
							if(row == checked.length){
								$('#check-all').prop('checked', true);
							}else{
								$('#check-all').prop('checked', false);
							}
						});
			
					},

					clickSubmit: function(actionValue){
                        var vue = this;
                        var totalAfterCalc = parseFloat(vue.hitungUlang().replace(/,/g, '')).toFixed(2);
                        var totalFormatted = Number(totalAfterCalc).toLocaleString("en-US");
                        var grandTotal = $("#grand_total").val();
                        $("#btn_action").val(actionValue);
                        Swal.fire({
                            width: 1000,
                             title: '<span style="font-size:40px">Konfirmasi</span>',
                             html: '<span style="font-size:40px">Total setelah hitung ulang adalah: <span style="color:red">' + totalFormatted +
                                  '</span> dan grand total di program: <span style="color:red">' + grandTotal + '</span>. Lanjut simpan?</span>',
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Ya, simpan',
                            cancelButtonText: 'Batal'
                        }).then((result) => {
                            console.log(result);
                            if (result.value) {
                                console.log("TES");
                                
                                $(that.elForm).submit(); // This triggers ajaxForm submit handler
                            }
                        });
                    },

					handleForm2: function () {
						var vue = this;
						
						window.DATETIME.initDatePicker();
			
						$(that.elForm).validate();
			
						$(that.elForm).ajaxForm({
							beforeSend: function () {
							    $("#tundabutton").attr('disabled','disabled');
							    $("#savebutton").attr('disabled','disabled');
							    $("#savebutton2").attr('disabled','disabled');
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
			
								if (vue.detailData.length == 0) {
									toastr.warning('Silahkan isi data terlebih dahulu!')
									$(that.elVue).unblock();
									$("#tundabutton").removeAttr("disabled");
							        $("#savebutton").removeAttr("disabled");
							        $("#savebutton2").removeAttr("disabled");
									return false;
								}
                                
								if(that.objectFindByKey(vue.detailData, 'total', '0').length){
									toastr.warning('Silahkan isi Quantity atau Harga terlebih dahulu!')
									$(that.elVue).unblock();
									$("#tundabutton").removeAttr("disabled");
							        $("#savebutton").removeAttr("disabled");
							        $("#savebutton2").removeAttr("disabled");
									return false;
								}
								if(that.objectFindByKeyLessThan(vue.detailData, 'lg_unit_qty', '0').length){
									toastr.warning('Ada quantity yg minus!')
									$(that.elVue).unblock();
									$("#tundabutton").removeAttr("disabled");
							        $("#savebutton").removeAttr("disabled");
							        $("#savebutton2").removeAttr("disabled");
									return false;
								}
								if(that.objectFindByKeyLessThan(vue.detailData, 'md_unit_qty', '0').length){
									toastr.warning('Ada quantity yg minus!')
									$(that.elVue).unblock();
									$("#tundabutton").removeAttr("disabled");
							        $("#savebutton").removeAttr("disabled");
							        $("#savebutton2").removeAttr("disabled");
									return false;
								}
								if(that.objectFindByKeyLessThan(vue.detailData, 'sm_unit_qty', '0').length){
									toastr.warning('Ada quantity yg minus!')
									$(that.elVue).unblock();
									$("#tundabutton").removeAttr("disabled");
							        $("#savebutton").removeAttr("disabled");
							        $("#savebutton2").removeAttr("disabled");
									return false;
								}
							},
							data: {
								vuedata: vue.detailData
							},
							dataType: "json",
							success: function (response) {
								$(that.elVue).unblock();
								
								if(response.status == "outofstock"){
									Swal.fire({
										title: "Stok tidak cukup!",
										text: response.message,
										icon: "error",
										button: false,
										timer: 4000
									  });
								}else{
									window.FORM.showNotification(response.message, response.status);
								}
			
								if (response.status == "success") {
									if(response.btn_action == "finish_print"){
										setTimeout(function () {
											window.location.href = that.urlPrintOut +response.id
											setTimeout(function () {
												window.location.href = that.urlIndex
											}, 1500);
										}, 1500);
									}else{
										setTimeout(function () {
											window.location.href = that.urlIndex
										}, 1500);
									}
								}
			
							}
						});
			
					},
                     
				},
				mounted: function () {
                    var vue = this;
					var id = $("#id").val();
					var hold_status = $("#hold_status").val();
					
                    if(id != 'new'){
						vue.handleData();
					}
					console.log(hold_status);
					if(hold_status == 1){
					    console.log(hold_status);
					    var paymentMethod = $("#payment-method-select").val();
						vue.$set(vue, 'paymentMethod', paymentMethod);
						vue.handlePayment2();
					}else{
					    var paymentMethod = $("#payment-method-select").val();
						vue.$set(vue, 'paymentMethod', paymentMethod);
						vue.handlePayment();
					}
					vue.handleCheckbox();
					vue.handleForm2();
					
						
					setTimeout(function () {
						// $(that.elForm).validate();

						// $(that.elVue).block({
						// 	message: '<h4>Please Wait..</h4>'
						// });

						that.handleForm();
						
						
						window.INPUT.handleCheckboxAll(that.elParentCheckbox, that.elSubCheckbox);

						// $(that.elVue).unblock();
					}, 500);
					// console.log(vue.detailData);
					
				}
			});

		},

		// form
		handleForm: function () {
			var that = this;

			window.DATETIME.initDatePicker();

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					$(that.elVue).block({
						message: '<h4>Please Wait..</h4>'
					});

					if (that.initVue.detailData.length == 0) {
						toastr.warning('Silahkan isi data terlebih dahulu!')
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.detailData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					window.FORM.showNotification(response.message, response.status);

					if (response.status == "success") {
						if(response.btn_action == "finish_print"){
							setTimeout(function () {
								window.location.href = that.urlPrintOut +response.id
								setTimeout(function () {
									window.location.href = that.urlIndex
								}, 1500);
							}, 1500);
						}else{
							setTimeout(function () {
								window.location.href = that.urlIndex
							}, 1500);
						}
					}

				}
			});

        },
        
		/**
		 * Mencari key dan value dari sebuah array yg dihasilkan
		 */
		objectFindByKey: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] === value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},
		objectFindByKeyLessThan: function (array, key, value) {
			var newArr = [];
			for (var i = 0; i < array.length; i++) {
				if (array[i][key] < value) {
					newArr.push(array[i]);
				}

			}
			return newArr;
		},

		arrayClean: function (array, deleteValue) {
			for (var i = 0; i < array.length; i++) {
				if (array[i] == deleteValue) {
					array.splice(i, 1);
					i--;
				}
			}
			return array;
		},
	}
})(jQuery);