<?php
/**
 * Warehouses Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Warehouses_model extends Model {

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_warehouses');

		$sql->order_by('warehouse_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('master_warehouses', $data);
	}

	public function update($where, $data) {
		$this->db->where($where);
		return $this->db->update('master_warehouses', $data);
	}

	public function delete($id) {
		$this->db->where('warehouse_id', $id);
		return $this->db->delete('master_warehouses');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('master_warehouses');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
