<?php

/**
 * Sales Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Purchase_returns_model extends Model
{

	public function purchasereturn_autonumber()
	{
		$sql = $this->db;

		$sql->select('RIGHT(purchase_return_headers.purchase_return_header_number, 3) as serial_number', FALSE);
		$sql->where('MONTH(purchase_return_header_date) = MONTH(CURRENT_DATE())');
		$sql->where('YEAR(purchase_return_header_date) = YEAR(CURRENT_DATE())');
		// $sql->where('SUBSTR(pembelian_headers.pembelian_header_number, 1, 2) = "'.$supp_code.'"');
		$sql->order_by('purchase_return_header_number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('purchase_return_headers');

		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 01;
		}

		$serial_number_generate = str_pad($serial_number, 3, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function get_purchase_order($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('pembelian_headers a');
		// $sql->join('master_suppliers b', 'b.supplier_id = a.pembelian_header_supplier_id', 'inner');

		// if ($search != '') {
		// 	$sql->like('pembelian_header_number', $search);
		// 	$sql->or_like('pembelian_header_date', $search);
		// }
		$sql->where($where);
		// $sql->where('status_paid', 0);
		$sql->order_by('pembelian_header_date asc');

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_header($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, a.timestamp as tmstamp_so');
		$sql->from('purchase_return_headers a');
		$sql->join('master_suppliers b', 'b.supplier_id = a.purchase_return_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_lite($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('
		a.purchase_return_detail_item_id, 
		a.purchase_return_detail_large_unit_quantity,
		a.purchase_return_detail_medium_unit_quantity, 
		a.purchase_return_detail_small_unit_quantity, 
		b.pembelian_header_id');
		$sql->from('purchase_return_details a');
		$sql->join('purchase_return_headers b', 'b.purchase_return_header_id = a.purchase_return_detail_header_id', 'left');
		// $sql->join('master_items c', 'c.item_id = a.purchase_return_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_detail($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_return_details a');
		$sql->join('purchase_return_headers b', 'b.purchase_return_header_id = a.purchase_return_detail_header_id', 'left');
		$sql->join('master_items c', 'c.item_id = a.purchase_return_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_detail_advance($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_return_details a');
		$sql->join('purchase_return_headers b', 'b.purchase_return_header_id = a.purchase_return_detail_header_id', 'left');
		$sql->join('master_items c', 'c.item_id = a.purchase_return_detail_item_id', 'left');
		$sql->join('master_suppliers d', 'd.supplier_id = b.purchase_return_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchasereturn_advance($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(a.purchase_return_detail_total) as total_return');
		$sql->from('purchase_return_details a');
		$sql->join('purchase_return_headers b', 'b.purchase_return_header_id = a.purchase_return_detail_header_id', 'left');
		$sql->join('master_items c', 'c.item_id = a.purchase_return_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('purchase_return_headers', $data);
		}

		return $this->db->insert('purchase_return_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('purchase_return_details', $data);
		}

		return $this->db->insert('purchase_return_details', $data);
	}

	public function update_header($id, $data)
	{
		$this->db->where('purchase_return_header_id', $id);
		return $this->db->update('purchase_return_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("purchase_return_header_id", $id);
		return $this->db->delete("purchase_return_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("purchase_return_detail_header_id", $id);
		return $this->db->delete("purchase_return_details");
	}

	public function update_lunas_po($data)
	{
		return $this->db->update_batch('pembelian_headers', $data, 'pembelian_header_id');
	}

	public function truncate_header()
	{
		return $this->db->empty_table("purchase_return_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("purchase_return_details");
	}
}
