<?php
/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Purchase_orders_model extends Model {

// 	public function purchaseorder_autonumber()
// 	{	
// 		$sql = $this->db;

// 		$sql->select('RIGHT(purchase_order_headers.purchase_order_header_number, 3) as serial_number', FALSE);
// // 		$sql->where('MONTH(purchase_order_header_date) = MONTH(CURRENT_DATE())');
// // 		$sql->where('SUBSTR(purchase_order_headers.purchase_order_header_number, 2, 3) = "'.$supp_code.'"');
//         $sql->order_by('CAST(RIGHT(purchase_order_headers.purchase_order_header_number, 3) AS UNSIGNED)', 'DESC');
// // 		$sql->order_by('purchase_order_header_number', 'DESC');
// 		$sql->limit(1);    
// 		$query = $sql->get('purchase_order_headers');  
// 		if($query->num_rows() > 0){         
// 			$data = $query->row();      
// 			$serial_number = intval($data->serial_number) + 1;    
// 		}
// 		else {          
// 			$serial_number = 01;    
// 		}

// 		$serial_number_generate = str_pad($serial_number, 3, "0", STR_PAD_LEFT);
// 		$result = $serial_number_generate;
// 		return $result;

// 	}
public function purchaseorder_autonumber()
{
    $sql = "
        SELECT RIGHT(purchase_order_header_number, 3) AS serial_number 
        FROM purchase_order_headers 
        WHERE MONTH(purchase_order_header_date) = MONTH(CURRENT_DATE())
        AND YEAR(purchase_order_header_date) = YEAR(CURRENT_DATE())
        ORDER BY CAST(RIGHT(purchase_order_header_number, 3) AS UNSIGNED) DESC 
        LIMIT 1
    ";
    $query = $this->db->query($sql);

    if ($query->num_rows() > 0) {
        $row = $query->row();
        $serial_number = intval($row->serial_number) + 1;
    } else {
        $serial_number = 1;
    }

    $serial_number_generate = str_pad($serial_number, 3, "0", STR_PAD_LEFT);
    return $serial_number_generate;
}




	public function purchaseorder_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*, , a.timestamp as tmstamp_po');
		$sql->from('purchase_order_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_order_header_supplier_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('purchase_order_details a');
	    $sql->join('master_items b', 'b.item_id = a.purchase_order_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail2($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('purchase_order_details a');
	    $sql->join('master_items b', 'b.item_id = a.purchase_order_detail_item_id', 'left');
	    $sql->join('master_groups c', 'c.group_id = b.item_group_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_advance($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('purchase_order_details a');
	    $sql->join('purchase_order_headers b', 'b.purchase_order_header_id = a.purchase_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.purchase_order_detail_item_id', 'left');
	    $sql->join('master_suppliers d', 'd.supplier_id = b.purchase_order_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_sum($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*, sum(purchase_order_detail_result_large + purchase_order_detail_result_medium + purchase_order_detail_result_small) as result');
	    $sql->from('purchase_order_details a');
	    $sql->join('purchase_order_headers b', 'b.purchase_order_header_id = a.purchase_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.purchase_order_detail_item_id', 'left');
	    $sql->join('master_suppliers d', 'd.supplier_id = b.purchase_order_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_headersearch($type='', $supplier='', $search='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_order_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_order_header_supplier_id', 'inner');

    	if ($search != '')
		{
			$sql->like('purchase_order_header_number', $search);
			$sql->or_like('purchase_order_header_date', $search);
		}

		$sql->where('purchase_order_header_supplier_id', $supplier);
		$sql->where('status_paid', 0);
		$sql->order_by('purchase_order_header_date asc');

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('purchase_order_headers', $data);
		}

		return $this->db->insert('purchase_order_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('purchase_order_details', $data);
		}

		return $this->db->insert('purchase_order_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('purchase_order_header_id', $id);
		return $this->db->update('purchase_order_headers', $data);
	}

	public function update_item_batch($data) {
		// $this->db->where('log_id', $where);
		return $this->db->update_batch('logs', $data, 'log_id');
	}

	public function update_master_item_batch($data) {
		return $this->db->update_batch('master_items', $data, 'item_id');
	}

	public function delete_header($id)
	{
		$this->db->where("purchase_order_header_id", $id);
		return $this->db->delete("purchase_order_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("purchase_order_detail_header_id", $id);
		return $this->db->delete("purchase_order_details");
	}

	public function delete_detail_advance($where)
	{
		$this->db->where($where);
		return $this->db->delete("purchase_order_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("purchase_order_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("purchase_order_details");
	}

}

?>
