<?php

/**
 * Account_headers Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Account_headers_model extends Model
{

	public function get_data($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_account_headers a');
		$sql->join('master_account_groups b', 'b.account_group_id = a.account_group_id', 'inner');

		$sql->order_by('account_header_number');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_child($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_account_header_childs a');
		$sql->join('master_account_headers b', 'b.account_header_id = a.account_header_id', 'left');

		$sql->order_by('account_header_child_number');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data)
	{
		return $this->db->insert('master_account_headers', $data);
	}

	public function save_child($data)
	{
		return $this->db->insert('master_account_header_childs', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('account_header_id', $id);
		return $this->db->update('master_account_headers', $data);
	}

	public function update_child($id, $data)
	{
		$this->db->where('account_header_child_id', $id);
		return $this->db->update('master_account_header_childs', $data);
	}

	public function delete($id)
	{
		$this->db->where('account_header_id', $id);
		return $this->db->delete('master_account_headers');
	}

	public function delete_child_account_header($id)
	{
		$this->db->where('account_header_id', $id);
		return $this->db->delete('master_account_header_childs');
	}

	public function delete_child($id)
	{
		$this->db->where('account_header_child_id', $id);
		return $this->db->delete('master_account_header_childs');
	}

	public function check_id($table, $where)
	{
		$this->db->select("*");
		$this->db->from($table);
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
