/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elItem: '.select-item',
		elDate: '.date-log',
		elStatus: '.select-status',

		urlRequestData: window.APP.siteUrl + 'adm/Report_stock/get_data_detail_card',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					item_name: '',
					date_log: '',
					status_name: '',
					lg_stock: '',
					lg_stock_awal: '',
					md_stock: '',
					sm_stock: '',
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;
						var val_item = $(that.elItem).val();
				// 		var val_warehouse = $('.select-warehouse').val();
				// 		var val_date = $(that.elDate).val();
				// 		var val_status   = $(that.elStatus).val();

						var text_item = $(that.elItem + ' option:selected').text();
				// 		var text_warehouse = $('.select-warehouse' + ' option:selected').text();
				// 		var text_status = $(that.elStatus + ' option:selected').text();

						vue.$set(vue, 'item_name', text_item);
				// 		vue.$set(vue, 'warehouse_name', text_warehouse);
				// 		vue.$set(vue, 'date_log', val_date);
				// 		vue.$set(vue, 'status_name', val_status);

						if (val_item == "") {
							toastr.warning('Silahkan pilih barang terlebih dahulu!')
						} else {
							$.ajax({
								url: that.urlRequestData,
								type: 'post',
								data: {
									'item': val_item,
								// 	'date_log': val_date,
								// 	'warehouse': val_warehouse
								},
								dataType: "json",
								beforeSend: function () {
									$(that.elVue).block({
										message: '<h4>Please Wait..</h4>'
									});
								},
								success: function (response) {
									vue.$set(vue, 'detailData', response['data']);
									vue.$set(vue, 'lg_stock', response['lg_stock']);
									vue.$set(vue, 'lg_stock_awal', response['lg_stock_awal']);
									vue.$set(vue, 'md_stock', response['md_stock']);
									vue.$set(vue, 'sm_stock', response['sm_stock']);
									$(that.elVue).unblock();
								}
							});
						}
					},

					exportExcel: function () {
						var vue = this;

						var val_item = $(that.elItem).val();
						if (val_item == "") {
							toastr.warning('Silahkan pilih barang terlebih dahulu!')
						} else {
							vue.getData();

							setTimeout(function () {
								window.location = window.APP.siteUrl + 'adm/report_stocks/export_excel_card';
							}, 500);
						}
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);