/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT_PURCHASE = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elDate_1: '.date_1',
		elDate_2: '.date_2',
		supplier_select: '#supplier-select',
		group_select: '#group-select',
		item_select: '#item-select',

		urlRequestDataSales: window.APP.siteUrl + 'adm/report_purchase/get_data',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					elDate_1: '',
					elDate_2: '',
					date_1: '',
					date_2: '',
					pembelian: false,
					rekap_barang: false,
					rekap_tipe: false,
					rekap_grup: false,
					totalIncome: 0,
					detailData: []
				},
				methods: {
					getData: function (val) {
						var vue = this;

						var val_date_1 = $(that.elDate_1).val();
						var val_date_2 = $(that.elDate_2).val();

						var val_supplier = $(that.supplier_select).val();
						var val_group    = $(that.group_select).val();
						var val_item     = $(that.item_select).val();


						if(val == "pembelian"){
							vue.pembelian             = true;
							vue.rekap_barang          = false;
							vue.rekap_tipe            = false;
							vue.rekap_grup            = false;
						}
						if(val == "rekap_barang"){
							vue.pembelian             = false;
							vue.rekap_barang          = true;
							vue.rekap_tipe            = false;
							vue.rekap_grup            = false;
						}
						if(val == "rekap_grup"){
							vue.pembelian             = false;
							vue.rekap_barang          = false;
							vue.rekap_tipe            = false;
							vue.rekap_grup            = true;
						}
						if(val == "rekap_tipe"){
							vue.pembelian             = false;
							vue.rekap_barang          = false;
							vue.rekap_tipe            = true;
							vue.rekap_grup            = false;
						}
						

						$.ajax({
							url: that.urlRequestDataSales,
							type: 'post',
							data: {
								'date_1'  : val_date_1,
								'date_2'  : val_date_2,
								'supplier': val_supplier,
								'group'   : val_group,
								'item'    : val_item,
								'val'     : val
							},
							dataType: "json",
							beforeSend : function() {
								$(that.elVue).block({
									message: '<h4>Please Wait..</h4>'
								});
							},
							success: function (response) {

								vue.$set(vue, 'detailData', response['data']);

								vue.$set(vue, 'date_1', response['date_1']);
								vue.$set(vue, 'date_2', response['date_2']);
								// vue.$set(vue, 'totalIncome', response['total_income']);

								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_purchase_ppn/export_excel_income';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);