<?php

/**
 * Purchase Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Sales extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_model');
		$this->load->model('Customers_model');
		$this->load->model('Dropshippers_model');
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Units_model');
		$this->load->model('Report_stock_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Penjualan';

		$this->twiggy_display('adm/sales/index', $data);
	}

	public function courrier()
	{
		$data['content_title'] = 'Kurir';

		$this->twiggy_display('adm/sales/courrier', $data);
	}

	public function get_data_header()
	{
		$data = [];

		$get_data = $this->Sales_model->sales_header()->result();
		if (logged_user('role') != 1) {
			$get_data = $this->Sales_model->sales_header(array('division' => logged_user('division')))->result();
		}

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$bgcolor = ($get_row->status == "1" ? "bg-success" : "");


				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->id,
					'number'       => $get_row->number,
					'number_order' => $get_row->number_order,
					'number_resi'  => $get_row->number_resi,
					'courier'      => $get_row->courier,
					'date'         => $get_row->date != '0000-00-00' ? indonesian_date($get_row->date) : $get_row->date,
					'customer'     => $get_row->cs_name,
					'total'        => number_format($get_row->total),
				// 	'dropshipper'  => $get_row->dropshipper,
					'status'       => $get_row->status,
					'bgcolor'      => $bgcolor
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function check()
	{
		$id = $this->input->post('id');
		$data = $this->input->post('data');

		$status = ($data == "0" ? "1" : "0");
		// $msg = ($data == "0" ? "Berhasil menampilkan barang pada Mobile Apps" : "Berhasil menyembunyikan barang dari Mobile Apps");
		$data = array(
			'status' => $status,
		);
		$update = $this->Sales_model->update_header($id, $data);

		$response = array(
			'message' => 'Berhasil',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function get_autonumber()
	{
		$id      = $this->input->post('id');
		$datenow = date('ym');
		$number_generator = '';
		$where   = array('supplier_id' => $id);
		$supplier_data  = $this->Customers_model->get_data($where)->row();

		if ($supplier_data) {
			$number_generator = $this->Sales_model->sales_autonumber();
		}

		$prefix     = 'B';
		$autonumber = $prefix . $datenow . '-' . $number_generator;

		$payment_term  = $supplier_data->supplier_payment_term;
		$date          = date_now();

		if ($supplier_data) {
			$payment_due = date('d/m/Y', strtotime($date . ' + ' . $supplier_data->supplier_payment_term . ' days'));
		}

		$response = [
			'autonumber'  => $autonumber,
			'payment_due' => $payment_due
		];

		echo json_encode($response);
	}


	public function edit($id = 'new')
	{
		$title       = "Tambah Penjualan";
		$header_data = array(null);
		$ppn_amount  = 0;
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
		// $prefix  = "PO100";
		// $datenow = date('Ym');
		// $number_generator = $this->Sales_model->sales_autonumber();
		// $autonumber = $prefix.$datenow.'-'.$number_generator;
		$autonumber = '';

		$date_text = date_now();
		$tmstamp   = date("H:i:s");

		if ($id != 'new') {
			$title       = "Edit Penjualan";
			$where       = array('id' => $id);
			$header_data = $this->Sales_model->sales_header($where)->row_array();
			$date_text   = $header_data['date'];
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['customer_data'] = $this->Customers_model->get_data()->result();
		$data['dropshipper_data'] = $this->Dropshippers_model->get_data()->result();
		$data['ppn_amount']    = $ppn_amount;


		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;
		$data['tmstamp']    = $tmstamp;

		$this->twiggy_display('adm/sales/edit', $data);
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('header_id' => $id);
		// $order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Sales_model->sales_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$where = array('item_id' => $get_row->item_id);
				$get_po = $this->Report_stock_model->get_purchase_detail_lite($where, '', 'item_id')->row();
				$get_so = $this->Report_stock_model->get_sales_detail_lite($where, '', 'item_id')->row();
				$get_st = $this->Report_stock_model->get_stock_detail_lite($where, '', 'item_id')->row();

				$stock_po = 0;
				$stock_so = 0;
				$stock_st = 0;

				if ($get_po) {
					$stock_po = $get_po->s_quantity;
				}

				if ($get_so) {
					$stock_so = $get_so->s_quantity;
				}

				if ($get_st) {
					$stock_st = $get_st->s_quantity;
				}

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->id,
					'detail_header_id' => $get_row->header_id,
					'id'               => $get_row->item_id,
					'code'             => $get_row->it_code,
					'name'             => $get_row->it_name,
					'stock'            => $stock_po + $stock_st - $stock_so + $get_row->quantity,
					'lg_unit'          => $get_row->unit,
					'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
					'lg_unit_qty'      => to_decimal($get_row->quantity),
					'lg_unit_prc'      => number_format($get_row->price),
					'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
					'result_large'     => $get_row->price,
					'md_unit'          => '',
					'md_unit_cnt'      => 0,
					'md_unit_qty'      => 0,
					'md_unit_prc'      => 0,
					'md_unit_slg'      => 0,
					'result_medium'    => 0,
					'sm_unit'          => '',
					'sm_unit_cnt'      => 0,
					'sm_unit_qty'      => 0,
					'sm_unit_prc'      => 0,
					'sm_unit_slg'      => 0,
					'result_small'     => 0,
					'discount'         => to_decimal($get_row->discount_percentage),
					'discount_total'   => number_format($get_row->discount_amount),
					'total'            => number_format($get_row->amount),

					'overprice_lg' => 0,
					'overprice_md' => 0,
					'overprice_sm' => 0,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/sales/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');
		$id   = $this->input->post('id');

		$get_data  = $this->Items_model->get_data_search($search)->result();

		if (logged_user('role') != 1) {
			$get_data  = $this->Items_model->get_data_search($search, '', array('division' => logged_user('division')))->result();
		}

		$no = 0;
		foreach ($get_data as $get_row) {

			$where = array('item_id' => $get_row->item_id);
			$get_po = $this->Report_stock_model->get_purchase_detail_lite($where, '', 'item_id')->row();
			$get_so = $this->Report_stock_model->get_sales_detail_lite($where, '', 'item_id')->row();
			$get_st = $this->Report_stock_model->get_stock_detail_lite($where, '', 'item_id')->row();

			$stock_po = 0;
			$stock_so = 0;
			$stock_st = 0;

			if ($get_po) {
				$stock_po = $get_po->s_quantity;
			}

			if ($get_so) {
				$stock_so = $get_so->s_quantity;
			}

			if ($get_st) {
				$stock_st = $get_st->s_quantity;
			}

			$sudahada = 0;
			if ($id != 'new') {
				$where_so    = array('header_id' => $id);
				$get_so_detail = $this->Sales_model->sales_detail($where_so)->row();
				if ($get_so_detail) {
					$sudahada = $get_so_detail->quantity;
				}
			}


			$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'code'             => $get_row->item_code,
				'name'             => $get_row->item_name,
				// 'group_id'         => $get_row->group_id,
				// 'group_name'       => $get_row->group_name,
				// 'group_child_id'   => $get_row->group_child_id,
				// 'group_child_name' => $get_row->group_child_name,
				'lg_unit'          => $get_row->large_unit,
				'stock'            => $stock_po + $stock_st - $stock_so + $sudahada,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_prc'      => number_format($get_row->last_selling_price_large_unit),
				'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
				'md_unit'          => $get_row->medium_unit,
				'md_unit_cnt'      => to_decimal($get_row->medium_unit_contain),
				'md_unit_prc'      => number_format($get_row->last_selling_price_medium_unit),
				'md_unit_slg'      => number_format($get_row->last_selling_price_medium_unit),
				'sm_unit'          => $get_row->small_unit,
				'sm_unit_cnt'      => to_decimal($get_row->small_unit_contain),
				'sm_unit_prc'      => number_format($get_row->last_selling_price_small_unit),
				'sm_unit_slg'      => number_format($get_row->last_selling_price_small_unit),
				'btncolor'         => '',
				'btnicon'          => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id           = $this->input->post('id');
		$number       = $this->input->post("number");
		$number_order = $this->input->post("number_order");
		$number_resi  = $this->input->post("number_resi");
		$courier      = $this->input->post("courier");
		$dropshipper  = $this->input->post("dropshipper");
		$date         = $this->input->post("date");
		$customer     = $this->input->post("customer");
		$grand_total  = $this->input->post("grand_total");
		$description  = $this->input->post("description");

		$arr_dropshippper = explode(':', $dropshipper);

		$vuedata  = $this->input->post('vuedata');

		$header_id = $id;

		$number      = ($id == "new" ? $this->Sales_model->sales_number() : $number);
		$header_data = [
			'date'          => change_format_date($date),
			'number'        => $number,
			'number_order'  => $number_order,
			'number_resi'   => $number_resi,
			'courier'       => $courier,
			'dropshipper_id'   => $arr_dropshippper[0],
			'dropshipper'   => $arr_dropshippper[1],
			'number'        => $number,
			'customer_name' => $customer,
			'total'         => trims($grand_total),
			'user_id'       => 1,
			'description'   => $description,
			'timestamp'		=> date_now(),
			'division'		=> logged_user('division')
		];

		$detail_data = [];

		// if save $id = new else update data
		if ($vuedata) {
			if ($id == "new") {
				// save header
				$save_header  = $this->Sales_model->save_header($header_data);

				if ($save_header) {
					$header_id = $this->db->insert_id();

					foreach ($vuedata as $row) {
						$detail_data[] = [
							'header_id'           => $header_id,
							'item_id'             => $row['id'],
							'item_code'           => $row['code'],
							'item_name'           => $row['name'],
							'quantity'            => trims($row['lg_unit_qty']),
							'unit'                => $row['lg_unit'],
							'price'               => trims($row['lg_unit_prc']),
							'discount_percentage' => trims($row['discount']),
							'discount_amount'     => trims($row['discount_total']),
							'amount'              => trims($row['total']),
							'division'			  => logged_user('division')
						];
					}

					$save_detail = $this->Sales_model->save_detail($detail_data, true);

					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$delete_detail = $this->Sales_model->delete_detail($id);

				if ($delete_detail) {

					$save_header  = $this->Sales_model->update_header($id, $header_data);

					if ($save_header) {

						foreach ($vuedata as $row) {
							$detail_data[] = [
								'header_id'           => $header_id,
								'item_code'           => $row['code'],
								'item_id'             => $row['id'],
								'item_name'           => $row['name'],
								'quantity'            => trims($row['lg_unit_qty']),
								'unit'                => $row['lg_unit'],
								'price'               => trims($row['lg_unit_prc']),
								'discount_percentage' => trims($row['discount']),
								'discount_amount'     => trims($row['discount_total']),
								'amount'              => trims($row['total']),
								'division'		      => logged_user('division')
							];
						}

						$save_detail = $this->Sales_model->save_detail($detail_data, true);

						if ($save_detail) {
							$msg    = "Berhasil menyimpan data";
							$status = "success";
						} else {
							$msg    = "Gagal menyimpan data #LOG-U01";
							$status = "error";
						}
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {

			$delete_header = $this->Sales_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Sales_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header  = array('purchase_order_header_id' => $id);
		$where_detail  = array('purchase_order_detail_header_id' => $id);
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');


		$header = $this->Sales_model->sales_header($where_header)->row_array();
		$detail = $this->Sales_model->sales_detail2($where_detail, 'group_order asc, item_name')->result();

		$data['content_title'] = 'Print Pembelian';
		$data['header'] = $header;
		$data['detail'] = $detail;
		// $data['config_receipt2'] = $config_receipt2;

		$this->twiggy_display('adm/sales/print_out', $data);
	}
}
