<?php

/**
 * Report_purchase PPN Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Report_purchase_dummy extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Report_purchase_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title']    = 'Laporan Pembelian';

		$data['supplier_data'] = $this->Report_purchase_model->get_supplier()->result();
		$data['group_data']    = $this->Report_purchase_model->get_group()->result();
		$data['item_data']     = $this->Report_purchase_model->get_item()->result();

		$this->twiggy_display('adm/report_purchase/index', $data);
	}

	public function get_data()
	{
		$date_1   = $this->input->post("date_1");
		$date_2   = $this->input->post("date_2");
		$supplier = $this->input->post("supplier");
		$group    = $this->input->post("group");
		$item     = $this->input->post("item");
		$val      = $this->input->post("val");

		$data  = [];
		$where = [];
		$total_outcome = 0;

		if (isset($date_1) && $date_1 != '') {
			$where['date >='] = change_format_date($date_1);
		}
		if (isset($date_2) && $date_2 != '') {
			$where['date <='] = change_format_date($date_2);
		}
		if (isset($supplier) && $supplier != '' && $supplier != '- Pilih -') {
			$where['supplier_name'] = $supplier;
		}
		if (isset($group) && $group != '' && $group != '- Pilih -') {
			$where['item_group_id'] = $group;
		}
		if (isset($item) && $item != '' && $item != '- Pilih -') {
			$where['a.item_id'] = $item;
		}
		if (logged_user('role') != 1) {
			$where['a.division'] = logged_user('division');
		}

		if ($val == "pembelian") {
			$this->getPurchase($where);
		}

		if ($val == "rekap_barang") {
			$this->getItemRecap($where);
		}

		if ($val == "rekap_grup") {
			$this->getRekapGrup($where);
		}

		if ($val == "rekap_tipe") {
			$this->getRekapTipe($where);
		}
	}

	public function getPurchase($where)
	{
		$get_data = $this->Report_purchase_model->get_purchase_detail($where, 'header_id asc, number')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'date'        => change_format_date($get_row->date, 'd/m/Y'),
					'number'      => $get_row->number,
					'item_code'   => $get_row->item_code,
					'item_name'   => $get_row->item_name,
					'price'       => number_format($get_row->price),
					'quantity'    => number_format($get_row->quantity),
					'amount'      => number_format($get_row->amount),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getItemRecap($where)
	{
		$get_data = $this->Report_purchase_model->get_item_recap($where, 'a.item_name asc')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
					'code'     => $get_row->item_code,
					'name'     => $get_row->item_name,
					'quantity' => number_format($get_row->total),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getRekapTipe($where)
	{
		$get_data = $this->Report_purchase_model->get_type_recap($where, 'e.type_name asc')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
					'name'     => $get_row->type_name,
					'quantity' => number_format($get_row->qty_total),
					'amount' => number_format($get_row->amount_total),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getRekapGrup($where)
	{
		$get_data = $this->Report_purchase_model->get_group_recap($where, 'd.group_name asc')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
					'name'     => $get_row->group_name,
					'quantity' => number_format($get_row->qty_total),
					'amount' => number_format($get_row->amount_total),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}
}
