<?php

/**
 * Purchase Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Pembelian extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Pembelian_model');
		$this->load->model('Customers_model');
		$this->load->model('Suppliers_model');
		$this->load->model('Items_model');
		$this->load->model('Groups_model');
		$this->load->model('Units_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Pembelian';

		$this->twiggy_display('adm/pembelian/index', $data);
	}

	public function get_data_header()
	{
		$data = [];

		$get_data = $this->Pembelian_model->pembelian_header()->result();
// 		if (logged_user('role') != 1) {
// 			$get_data = $this->Pembelian_model->pembelian_header(array('division' => logged_user('division')))->result();
// 		}
		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'id'          => $get_row->pembelian_header_id,
					'number'      => $get_row->pembelian_header_number,
					'date'        => indonesian_date($get_row->pembelian_header_date),
					'supplier'    => $get_row->pembelian_header_supplier_name,
					'total'       => number_format($get_row->pembelian_header_total),
					'description' => $get_row->pembelian_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title       = "Tambah Pembelian";
		$header_data = array(null);
		$ppn_amount  = 0;
		$ppn_amount  = (empty($ppn_data) ? 0 : to_decimal($ppn_data->amount));
		// $prefix  = "PO100";
		// $datenow = date('Ym');
		// $number_generator = $this->Pembelian_model->purchase_autonumber();
		// $autonumber = $prefix.$datenow.'-'.$number_generator;
		$autonumber = '';

		$date_text = date_now();
		$tmstamp   = date("H:i:s");

		if ($id != 'new') {
			$title       = "Edit Pembelian";
			$where       = array('id' => $id);
			$header_data = $this->Pembelian_model->pembelian_header($where)->row_array();
			$date_text   = $header_data['pembelian_header_date'];
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['supplier_data'] = $this->Suppliers_model->get_data()->result();
		$data['ppn_amount']    = $ppn_amount;


		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;
		$data['tmstamp']    = $tmstamp;

		$this->twiggy_display('adm/pembelian/edit', $data);
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('pembelian_detail_header_id' => $id);
		// $order       = array('item_name' => 'asc');

		$data = [];
		$get_data = $this->Pembelian_model->pembelian_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->pembelian_detail_id,
					'detail_header_id' => $get_row->pembelian_detail_header_id,
					'id'               => $get_row->pembelian_detail_item_id,
					'code'             => $get_row->it_code,//master_item
					'name'             => $get_row->it_name,//master_item
					'lg_unit'          => $get_row->unit,//master_item
					'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),//master_item
					'lg_unit_qty'      => to_decimal($get_row->pembelian_detail_quantity),
					'lg_unit_prc'      => number_format($get_row->pembelian_detail_price),
					'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),//master_item
					'result_large'     => $get_row->pembelian_detail_price,
					'md_unit'          => '',
					'md_unit_cnt'      => 0,
					'md_unit_qty'      => 0,
					'md_unit_prc'      => 0,
					'md_unit_slg'      => 0,
					'result_medium'    => 0,
					'sm_unit'          => '',
					'sm_unit_cnt'      => 0,
					'sm_unit_qty'      => 0,
					'sm_unit_prc'      => 0,
					'sm_unit_slg'      => 0,
					'result_small'     => 0,
					'discount'         => to_decimal($get_row->pembelian_detail_discount_percentage),
					'discount_total'   => number_format($get_row->pembelian_detail_discount_amount),
					'total'            => number_format($get_row->pembelian_detail_amount),

					'overprice_lg' => 0,
					'overprice_md' => 0,
					'overprice_sm' => 0,
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Barang';
		$this->twiggy_display('adm/pembelian/embed', $data);
	}

	public function get_data_embed()
	{
		$data = [];
		$response = [];
		$search   = $this->input->post('search');

		// $get_data  = $this->Items_model->get_data_search($search)->result();

		$get_data  = $this->Items_model->get_data_search($search)->result();

		

		$no = 0;
		foreach ($get_data as $get_row) {
			$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'code'             => $get_row->item_code,
				'name'             => $get_row->item_name,
				'lg_unit'          => $get_row->large_unit,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_prc'      => number_format($get_row->last_selling_price_large_unit),
				'lg_unit_slg'      => number_format($get_row->last_selling_price_large_unit),
				'md_unit'          => "",
				'md_unit_cnt'      => to_decimal(0),
				'md_unit_prc'      => number_format(0),
				'md_unit_slg'      => number_format(0),
				'sm_unit'          => "",
				'sm_unit_cnt'      => to_decimal(0),
				'sm_unit_prc'      => number_format(0),
				'sm_unit_slg'      => number_format(0),
				'btncolor'         => '',
				'btnicon'          => '',
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}
	public function get_data_barcode()
	{
		$data = [];
		$response = [];
		$barcode   = $this->input->post('barcode');

		$get_data  = $this->Items_model->get_data_search($barcode)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			

			if($get_row->item_code == $barcode){
				$data[] = array(
				'no'               => $no,
				'id'               => $get_row->item_id,
				'name'             => $get_row->item_name,
				'code'             => $get_row->item_code,
				'lg_unit'          => $get_row->large_unit,
				'lg_unit_cnt'      => to_decimal($get_row->large_unit_contain),
				'lg_unit_qty_old'=> 0,
				'lg_unit_qty'=> 1,
				'lg_unit_prc'      =>  number_format($get_row->last_selling_price_large_unit),
				// 'stock'            => $stock_po + $stock_st - $stock_so,
				'tipe_barcode' => 'besar',
				'total_small' => 0,
				'total_medium' => 0,
				'total_large' => 0,
				'btncolor'         => '',
				'btnicon'          => '',
				);
			}

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$supplier       = $this->input->post("supplier");
		$grand_total    = $this->input->post("grand_total");
		$description    = $this->input->post("description");

		$arr_supplier = explode(':', $supplier);
		// echo json_encode($arr[1]);
		// die();
		$vuedata  = $this->input->post('vuedata');
		
// 		var_dump($vuedata);

		$header_id = $id;

		$header_data = [
			'pembelian_header_date'          => change_format_date($date),
			'pembelian_header_number'        => $number,
			'pembelian_header_supplier_id'   => $arr_supplier[0],
			'pembelian_header_supplier_name' => $arr_supplier[1],
			'pembelian_header_total'         => trims($grand_total),
			'pembelian_header_user_id'       => 1,
			'pembelian_header_description'   => $description,
			'pembelian_header_division'      => logged_user('division')
		];

		$detail_data = [];

		// if save $id = new else update data
		if ($vuedata) {
			if ($id == "new") {
				// save header
				$save_header  = $this->Pembelian_model->save_header($header_data);

				if ($save_header) {
					$header_id = $this->db->insert_id();

					foreach ($vuedata as $row) {
						$detail_data[] = [
							'pembelian_detail_header_id'           => $header_id,
							'pembelian_detail_item_id'             => $row['id'],
							'pembelian_detail_item_code'           => $row['code'],
							'pembelian_detail_item_name'           => $row['name'],
							'pembelian_detail_quantity'            => trims($row['lg_unit_qty']),
							'pembelian_detail_unit'                => $row['lg_unit'],
							'pembelian_detail_price'               => trims($row['lg_unit_prc']),
							'pembelian_detail_discount_percentage' => trims($row['discount']),
							'pembelian_detail_discount_amount'     => trims($row['discount_total']),
							'pembelian_detail_amount'              => trims($row['total']),
							'pembelian_detail_division'			  => logged_user('division')
						];
					}

					$save_detail = $this->Pembelian_model->save_detail($detail_data, true);

					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$delete_detail = $this->Pembelian_model->delete_detail($id);

				if ($delete_detail) {

					$save_header  = $this->Pembelian_model->update_header($id, $header_data);

					if ($save_header) {

						foreach ($vuedata as $row) {
							$detail_data[] = [
								'pembelian_detail_header_id'           => $header_id,
								'pembelian_detail_item_id'             => $row['id'],
								'pembelian_detail_item_code'           => $row['code'],
								'pembelian_detail_item_name'           => $row['name'],
								'pembelian_detail_quantity'            => trims($row['lg_unit_qty']),
								'pembelian_detail_unit'                => $row['lg_unit'],
								'pembelian_detail_price'               => trims($row['lg_unit_prc']),
								'pembelian_detail_discount_percentage' => trims($row['discount']),
								'pembelian_detail_discount_amount'     => trims($row['discount_total']),
								'pembelian_detail_amount'              => trims($row['total']),
								'pembelian_detail_division'		      => logged_user('division')
							];
						}

						$save_detail = $this->Pembelian_model->save_detail($detail_data, true);

						if ($save_detail) {
							$msg    = "Berhasil menyimpan data";
							$status = "success";
						} else {
							$msg    = "Gagal menyimpan data #LOG-U01";
							$status = "error";
						}
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			}
		} else {
			$msg    = "Gagal menyimpan data";
			$status = "error";
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'detail_data'  => $detail_data,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {

			$delete_header = $this->Pembelian_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Pembelian_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header  = array('purchase_order_header_id' => $id);
		$where_detail  = array('purchase_order_detail_header_id' => $id);
		$where_config2 = array('ppn_status' => '2', 'is_active' => '1');


		$header = $this->Pembelian_model->pembelian_header($where_header)->row_array();
		$detail = $this->Pembelian_model->pembelian_detail2($where_detail, 'group_order asc, item_name')->result();

		$data['content_title'] = 'Print Pembelian';
		$data['header'] = $header;
		$data['detail'] = $detail;
		// $data['config_receipt2'] = $config_receipt2;

		$this->twiggy_display('adm/purchase/print_out', $data);
	}
}
