<?php

/**
 * Divisions Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Divisions extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Divisions_model');
	}

	public function index()
	{
		$data['content_title'] = 'Divisi';

		// $this->session->userdata('role')

		$this->twiggy_display('adm/divisions/index', $data);
	}

	public function get_data()
	{
		$data = [];
		$get_data = $this->Divisions_model->get_data()->result();

		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'       => $no,
					'id'       => $get_row->division_id,
					'name'     => $get_row->division_name,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title    = "Tambah";
		$get_data = array();

		if ($id != 'new') {
			$title    = "Edit";
			$where = array('division_id' => $id);
			$get_data = $this->Divisions_model->get_data($where)->row_array();
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['get_data']      = $get_data;

		$this->twiggy_display('adm/divisions/edit', $data);
	}

	public function save()
	{
		// post
		$id       = $this->input->post('id');
		$name     = $this->input->post('name');
		$action   = $this->input->post('action');

		$data_save = array(
			'division_name'     => $name,
		);

		if ($id == 'new') {
			$convert = convert_button($action, $id);
			$save = $this->Divisions_model->save($data_save);
		} else {
			$convert = convert_button($action, $id);
			$save = $this->Divisions_model->update($id, $data_save);
		}

		if ($save) {
			$response = array(
				'status'  => 'success',
				'message' => 'Berhasil menyimpan data',
				'id'      => $convert
			);
		} else {
			$response = array(
				'status'  => 'error',
				'message' => 'Gagal menyimpan data',
				'id'      => $convert
			);
		}

		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$delete_type = $this->Divisions_model->delete($row);
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function check_id()
	{
		$name  = $this->input->post('id');
		$where = array('division_name' => $name);

		$check = $this->Divisions_model->check_id($where);

		if ($check) {
			$response = array('status' => true);
		} else {
			$response = array('status' => false);
		}

		output_json($response);
	}
}
